/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.cli;

import org.apache.avalon.excalibur.cli.CLOptionDescriptor;

public final class CLUtil {
    protected static int MAX_DESCRIPTION_COLUMN_LENGTH = 60;

    public static StringBuffer describeOptions(CLOptionDescriptor[] options) {
        String lSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < options.length) {
            char ch = (char)options[i].getId();
            String name = options[i].getName();
            String description = options[i].getDescription();
            boolean needComma = false;
            sb.append('\t');
            if (Character.isLetter(ch)) {
                sb.append("-");
                sb.append(ch);
                needComma = true;
            }
            if (name != null) {
                if (needComma) {
                    sb.append(", ");
                }
                sb.append("--");
                sb.append(name);
                sb.append(lSep);
            }
            if (description != null) {
                while (description.length() > MAX_DESCRIPTION_COLUMN_LENGTH) {
                    String descriptionPart = description.substring(0, MAX_DESCRIPTION_COLUMN_LENGTH);
                    description = description.substring(MAX_DESCRIPTION_COLUMN_LENGTH);
                    sb.append("\t\t");
                    sb.append(descriptionPart);
                    sb.append(lSep);
                }
                sb.append("\t\t");
                sb.append(description);
                sb.append(lSep);
            }
            ++i;
        }
        return sb;
    }

    private CLUtil() {
    }
}

