/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;

public class DirectoryScanner
implements FileScanner {
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**"};
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected boolean haveSlowResults = false;

    protected static boolean matchPatternStart(String string, String string2) {
        if (string2.startsWith(File.separator) != string.startsWith(File.separator)) {
            return false;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Vector<String> vector2 = new Vector<String>();
        stringTokenizer = new StringTokenizer(string2, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            vector2.addElement(stringTokenizer.nextToken());
        }
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = 0;
        int n4 = vector2.size() - 1;
        while (n <= n2 && n3 <= n4) {
            String string3 = (String)vector.elementAt(n);
            if (string3.equals("**")) break;
            if (!DirectoryScanner.match(string3, (String)vector2.elementAt(n3))) {
                return false;
            }
            ++n;
            ++n3;
        }
        if (n3 > n4) {
            return true;
        }
        return n <= n2;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean matchPath(String var0, String var1_1) {
        if (var1_1.startsWith(File.separator) != var0.startsWith(File.separator)) {
            return false;
        }
        var2_2 = new Vector<String>();
        var3_3 = new StringTokenizer(var0, File.separator);
        while (var3_3.hasMoreTokens()) {
            var2_2.addElement(var3_3.nextToken());
        }
        var4_4 = new Vector<String>();
        var3_3 = new StringTokenizer(var1_1, File.separator);
        while (var3_3.hasMoreTokens()) {
            var4_4.addElement(var3_3.nextToken());
        }
        var5_5 = 0;
        var6_6 = var2_2.size() - 1;
        var7_7 = 0;
        var8_8 = var4_4.size() - 1;
        while (var5_5 <= var6_6 && var7_7 <= var8_8) {
            var9_9 = (String)var2_2.elementAt(var5_5);
            if (var9_9.equals("**")) break;
            if (!DirectoryScanner.match(var9_9, (String)var4_4.elementAt(var7_7))) {
                return false;
            }
            ++var5_5;
            ++var7_7;
        }
        if (var7_7 > var8_8) {
            var9_10 = var5_5;
            while (var9_10 <= var6_6) {
                if (!var2_2.elementAt(var9_10).equals("**")) {
                    return false;
                }
                ++var9_10;
            }
            return true;
        }
        if (var5_5 <= var6_6) ** GOTO lbl40
        return false;
        while (!(var9_9 = (String)var2_2.elementAt(var6_6)).equals("**")) {
            if (!DirectoryScanner.match(var9_9, (String)var4_4.elementAt(var8_8))) {
                return false;
            }
            --var6_6;
            --var8_8;
lbl40:
            // 2 sources

            if (var5_5 <= var6_6 && var7_7 <= var8_8) continue;
        }
        if (var7_7 <= var8_8) ** GOTO lbl81
        var9_11 = var5_5;
        while (var9_11 <= var6_6) {
            if (!var2_2.elementAt(var9_11).equals("**")) {
                return false;
            }
            ++var9_11;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            var9_12 = -1;
            var10_14 = var5_5 + 1;
            while (var10_14 <= var6_6) {
                if (var2_2.elementAt(var10_14).equals("**")) {
                    var9_12 = var10_14;
                    break;
                }
                ++var10_14;
            }
            if (var9_12 == var5_5 + 1) {
                ++var5_5;
                continue;
            }
            var11_15 = var9_12 - var5_5 - 1;
            var12_16 = var8_8 - var7_7 + 1;
            var13_17 = -1;
            var14_18 = 0;
            while (var14_18 <= var12_16 - var11_15) {
                block22: {
                    var15_19 = 0;
                    while (var15_19 < var11_15) {
                        var16_20 = (String)var2_2.elementAt(var5_5 + var15_19 + 1);
                        if (DirectoryScanner.match(var16_20, var17_21 = (String)var4_4.elementAt(var7_7 + var14_18 + var15_19))) {
                            ++var15_19;
                            continue;
                        }
                        break block22;
                    }
                    var13_17 = var7_7 + var14_18;
                    break;
                }
                ++var14_18;
            }
            if (var13_17 == -1) {
                return false;
            }
            var5_5 = var9_12;
            var7_7 = var13_17 + var11_15;
lbl81:
            // 3 sources

            ** while (var5_5 != var6_6 && var7_7 <= var8_8)
        }
lbl82:
        // 1 sources

        var9_13 = var5_5;
        while (var9_13 <= var6_6) {
            if (!var2_2.elementAt(var9_13).equals("**")) {
                return false;
            }
            ++var9_13;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String var0, String var1_1) {
        var2_2 = var0.toCharArray();
        var3_3 = var1_1.toCharArray();
        var4_4 = 0;
        var5_5 = var2_2.length - 1;
        var6_6 = 0;
        var7_7 = var3_3.length - 1;
        var9_8 = false;
        var10_9 = 0;
        while (var10_9 < var2_2.length) {
            if (var2_2[var10_9] == '*') {
                var9_8 = true;
                break;
            }
            ++var10_9;
        }
        if (!var9_8) {
            if (var5_5 != var7_7) {
                return false;
            }
            var11_10 = 0;
            while (var11_10 <= var5_5) {
                var8_14 = var2_2[var11_10];
                if (var8_14 != '?' && var8_14 != var3_3[var11_10]) {
                    return false;
                }
                ++var11_10;
            }
            return true;
        }
        if (var5_5 != 0) ** GOTO lbl32
        return true;
lbl-1000:
        // 1 sources

        {
            if (var8_15 != '?' && var8_15 != var3_3[var6_6]) {
                return false;
            }
            ++var4_4;
            ++var6_6;
lbl32:
            // 2 sources

            ** while ((var8_15 = var2_2[var4_4]) != '*' && var6_6 <= var7_7)
        }
lbl33:
        // 1 sources

        if (var6_6 <= var7_7) ** GOTO lbl45
        var11_11 = var4_4;
        while (var11_11 <= var5_5) {
            if (var2_2[var11_11] != '*') {
                return false;
            }
            ++var11_11;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (var8_15 != '?' && var8_15 != var3_3[var7_7]) {
                return false;
            }
            --var5_5;
            --var7_7;
lbl45:
            // 2 sources

            ** while ((var8_15 = var2_2[var5_5]) != '*' && var6_6 <= var7_7)
        }
lbl46:
        // 1 sources

        if (var6_6 <= var7_7) ** GOTO lbl86
        var11_12 = var4_4;
        while (var11_12 <= var5_5) {
            if (var2_2[var11_12] != '*') {
                return false;
            }
            ++var11_12;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            var11_13 = -1;
            var12_16 = var4_4 + 1;
            while (var12_16 <= var5_5) {
                if (var2_2[var12_16] == '*') {
                    var11_13 = var12_16;
                    break;
                }
                ++var12_16;
            }
            if (var11_13 == var4_4 + 1) {
                ++var4_4;
                continue;
            }
            var13_17 = var11_13 - var4_4 - 1;
            var14_18 = var7_7 - var6_6 + 1;
            var15_19 = -1;
            var16_20 = 0;
            while (var16_20 <= var14_18 - var13_17) {
                block24: {
                    var17_21 = 0;
                    while (var17_21 < var13_17) {
                        var8_15 = var2_2[var4_4 + var17_21 + 1];
                        if (var8_15 == '?' || var8_15 == var3_3[var6_6 + var16_20 + var17_21]) {
                            ++var17_21;
                            continue;
                        }
                        break block24;
                    }
                    var15_19 = var6_6 + var16_20;
                    break;
                }
                ++var16_20;
            }
            if (var15_19 == -1) {
                return false;
            }
            var4_4 = var11_13;
            var6_6 = var15_19 + var13_17;
lbl86:
            // 3 sources

            ** while (var4_4 != var5_5 && var6_6 <= var7_7)
        }
lbl87:
        // 1 sources

        var11_13 = var4_4;
        while (var11_13 <= var5_5) {
            if (var2_2[var11_13] != '*') {
                return false;
            }
            ++var11_13;
        }
        return true;
    }

    public void setBasedir(String string) {
        this.setBasedir(new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            this.includes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.includes[n] = string;
                ++n;
            }
        }
    }

    public void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.excludes[n] = string;
                ++n;
            }
        }
    }

    public void scan() {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                this.dirsIncluded.addElement("");
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.scandir(this.basedir, "", true);
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            this.scandir(new File(this.basedir, (String)objectArray[n]), (String)objectArray[n] + File.separator, false);
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            if (!this.couldHoldIncluded((String)objectArray2[n2])) {
                this.scandir(new File(this.basedir, (String)objectArray2[n2]), (String)objectArray2[n2] + File.separator, false);
            }
            ++n2;
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File file, String string, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = string + stringArray[n];
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        this.dirsIncluded.addElement(string2);
                        if (bl) {
                            this.scandir(file2, string2 + File.separator, bl);
                        }
                    } else {
                        this.dirsExcluded.addElement(string2);
                    }
                } else {
                    this.dirsNotIncluded.addElement(string2);
                    if (bl && this.couldHoldIncluded(string2)) {
                        this.scandir(file2, string2 + File.separator, bl);
                    }
                }
                if (!bl) {
                    this.scandir(file2, string2 + File.separator, bl);
                }
            } else if (file2.isFile()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        this.filesIncluded.addElement(string2);
                    } else {
                        this.filesExcluded.addElement(string2);
                    }
                } else {
                    this.filesNotIncluded.addElement(string2);
                }
            }
            ++n;
        }
    }

    protected boolean isIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPath(this.includes[n], string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[n], string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isExcluded(String string) {
        int n = 0;
        while (n < this.excludes.length) {
            if (DirectoryScanner.matchPath(this.excludes[n], string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] getIncludedFiles() {
        int n = this.filesIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.filesIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        int n = this.filesNotIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.filesNotIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        int n = this.filesExcluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.filesExcluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getIncludedDirectories() {
        int n = this.dirsIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.dirsIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        int n = this.dirsNotIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.dirsNotIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        int n = this.dirsExcluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.dirsExcluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void addDefaultExcludes() {
        int n = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n + DEFAULTEXCLUDES.length];
        if (n > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n);
        }
        int n2 = 0;
        while (n2 < DEFAULTEXCLUDES.length) {
            stringArray[n2 + n] = DEFAULTEXCLUDES[n2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++n2;
        }
        this.excludes = stringArray;
    }
}

