/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;

public class DirectoryScanner
implements FileScanner {
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc"};
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;

    protected static boolean matchPatternStart(String string, String string2) {
        return DirectoryScanner.matchPatternStart(string, string2, true);
    }

    protected static boolean matchPatternStart(String string, String string2, boolean bl) {
        if (string2.startsWith(File.separator) != string.startsWith(File.separator)) {
            return false;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Vector<String> vector2 = new Vector<String>();
        stringTokenizer = new StringTokenizer(string2, File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            vector2.addElement(stringTokenizer.nextToken());
        }
        int n = 0;
        int n2 = vector.size() - 1;
        int n3 = 0;
        int n4 = vector2.size() - 1;
        while (n <= n2 && n3 <= n4) {
            String string3 = (String)vector.elementAt(n);
            if (string3.equals("**")) break;
            if (!DirectoryScanner.match(string3, (String)vector2.elementAt(n3), bl)) {
                return false;
            }
            ++n;
            ++n3;
        }
        if (n3 > n4) {
            return true;
        }
        return n <= n2;
    }

    protected static boolean matchPath(String string, String string2) {
        return DirectoryScanner.matchPath(string, string2, true);
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean matchPath(String var0, String var1_1, boolean var2_2) {
        if (var1_1.startsWith(File.separator) != var0.startsWith(File.separator)) {
            return false;
        }
        var3_3 = new Vector<String>();
        var4_4 = new StringTokenizer(var0, File.separator);
        while (var4_4.hasMoreTokens()) {
            var3_3.addElement(var4_4.nextToken());
        }
        var5_5 = new Vector<String>();
        var4_4 = new StringTokenizer(var1_1, File.separator);
        while (var4_4.hasMoreTokens()) {
            var5_5.addElement(var4_4.nextToken());
        }
        var6_6 = 0;
        var7_7 = var3_3.size() - 1;
        var8_8 = 0;
        var9_9 = var5_5.size() - 1;
        while (var6_6 <= var7_7 && var8_8 <= var9_9) {
            var10_10 = (String)var3_3.elementAt(var6_6);
            if (var10_10.equals("**")) break;
            if (!DirectoryScanner.match(var10_10, (String)var5_5.elementAt(var8_8), var2_2)) {
                return false;
            }
            ++var6_6;
            ++var8_8;
        }
        if (var8_8 > var9_9) {
            var10_11 = var6_6;
            while (var10_11 <= var7_7) {
                if (!var3_3.elementAt(var10_11).equals("**")) {
                    return false;
                }
                ++var10_11;
            }
            return true;
        }
        if (var6_6 <= var7_7) ** GOTO lbl40
        return false;
        while (!(var10_10 = (String)var3_3.elementAt(var7_7)).equals("**")) {
            if (!DirectoryScanner.match(var10_10, (String)var5_5.elementAt(var9_9), var2_2)) {
                return false;
            }
            --var7_7;
            --var9_9;
lbl40:
            // 2 sources

            if (var6_6 <= var7_7 && var8_8 <= var9_9) continue;
        }
        if (var8_8 <= var9_9) ** GOTO lbl81
        var10_12 = var6_6;
        while (var10_12 <= var7_7) {
            if (!var3_3.elementAt(var10_12).equals("**")) {
                return false;
            }
            ++var10_12;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            var10_13 = -1;
            var11_15 = var6_6 + 1;
            while (var11_15 <= var7_7) {
                if (var3_3.elementAt(var11_15).equals("**")) {
                    var10_13 = var11_15;
                    break;
                }
                ++var11_15;
            }
            if (var10_13 == var6_6 + 1) {
                ++var6_6;
                continue;
            }
            var12_16 = var10_13 - var6_6 - 1;
            var13_17 = var9_9 - var8_8 + 1;
            var14_18 = -1;
            var15_19 = 0;
            while (var15_19 <= var13_17 - var12_16) {
                block22: {
                    var16_20 = 0;
                    while (var16_20 < var12_16) {
                        var17_21 = (String)var3_3.elementAt(var6_6 + var16_20 + 1);
                        if (DirectoryScanner.match(var17_21, var18_22 = (String)var5_5.elementAt(var8_8 + var15_19 + var16_20), var2_2)) {
                            ++var16_20;
                            continue;
                        }
                        break block22;
                    }
                    var14_18 = var8_8 + var15_19;
                    break;
                }
                ++var15_19;
            }
            if (var14_18 == -1) {
                return false;
            }
            var6_6 = var10_13;
            var8_8 = var14_18 + var12_16;
lbl81:
            // 3 sources

            ** while (var6_6 != var7_7 && var8_8 <= var9_9)
        }
lbl82:
        // 1 sources

        var10_14 = var6_6;
        while (var10_14 <= var7_7) {
            if (!var3_3.elementAt(var10_14).equals("**")) {
                return false;
            }
            ++var10_14;
        }
        return true;
    }

    protected static boolean match(String string, String string2) {
        return DirectoryScanner.match(string, string2, true);
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String var0, String var1_1, boolean var2_2) {
        var3_3 = var0.toCharArray();
        var4_4 = var1_1.toCharArray();
        var5_5 = 0;
        var6_6 = var3_3.length - 1;
        var7_7 = 0;
        var8_8 = var4_4.length - 1;
        var10_9 = false;
        var11_10 = 0;
        while (var11_10 < var3_3.length) {
            if (var3_3[var11_10] == '*') {
                var10_9 = true;
                break;
            }
            ++var11_10;
        }
        if (!var10_9) {
            if (var6_6 != var8_8) {
                return false;
            }
            var12_11 = 0;
            while (var12_11 <= var6_6) {
                var9_15 = var3_3[var12_11];
                if (var9_15 != '?') {
                    if (var2_2 && var9_15 != var4_4[var12_11]) {
                        return false;
                    }
                    if (!var2_2 && Character.toUpperCase(var9_15) != Character.toUpperCase(var4_4[var12_11])) {
                        return false;
                    }
                }
                ++var12_11;
            }
            return true;
        }
        if (var6_6 != 0) ** GOTO lbl38
        return true;
lbl-1000:
        // 1 sources

        {
            if (var9_16 != '?') {
                if (var2_2 && var9_16 != var4_4[var7_7]) {
                    return false;
                }
                if (!var2_2 && Character.toUpperCase(var9_16) != Character.toUpperCase(var4_4[var7_7])) {
                    return false;
                }
            }
            ++var5_5;
            ++var7_7;
lbl38:
            // 2 sources

            ** while ((var9_16 = var3_3[var5_5]) != '*' && var7_7 <= var8_8)
        }
lbl39:
        // 1 sources

        if (var7_7 <= var8_8) ** GOTO lbl54
        var12_12 = var5_5;
        while (var12_12 <= var6_6) {
            if (var3_3[var12_12] != '*') {
                return false;
            }
            ++var12_12;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (var9_16 != '?') {
                if (var2_2 && var9_16 != var4_4[var8_8]) {
                    return false;
                }
                if (!var2_2 && Character.toUpperCase(var9_16) != Character.toUpperCase(var4_4[var8_8])) {
                    return false;
                }
            }
            --var6_6;
            --var8_8;
lbl54:
            // 2 sources

            ** while ((var9_16 = var3_3[var6_6]) != '*' && var7_7 <= var8_8)
        }
lbl55:
        // 1 sources

        if (var7_7 <= var8_8) ** GOTO lbl95
        var12_13 = var5_5;
        while (var12_13 <= var6_6) {
            if (var3_3[var12_13] != '*') {
                return false;
            }
            ++var12_13;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            var12_14 = -1;
            var13_17 = var5_5 + 1;
            while (var13_17 <= var6_6) {
                if (var3_3[var13_17] == '*') {
                    var12_14 = var13_17;
                    break;
                }
                ++var13_17;
            }
            if (var12_14 == var5_5 + 1) {
                ++var5_5;
                continue;
            }
            var14_18 = var12_14 - var5_5 - 1;
            var15_19 = var8_8 - var7_7 + 1;
            var16_20 = -1;
            var17_21 = 0;
            while (var17_21 <= var15_19 - var14_18) {
                block30: {
                    var18_22 = 0;
                    while (var18_22 < var14_18) {
                        var9_16 = var3_3[var5_5 + var18_22 + 1];
                        if (var9_16 == '?' || (!var2_2 || var9_16 == var4_4[var7_7 + var17_21 + var18_22]) && (var2_2 || Character.toUpperCase(var9_16) == Character.toUpperCase(var4_4[var7_7 + var17_21 + var18_22]))) {
                            ++var18_22;
                            continue;
                        }
                        break block30;
                    }
                    var16_20 = var7_7 + var17_21;
                    break;
                }
                ++var17_21;
            }
            if (var16_20 == -1) {
                return false;
            }
            var5_5 = var12_14;
            var7_7 = var16_20 + var14_18;
lbl95:
            // 3 sources

            ** while (var5_5 != var6_6 && var7_7 <= var8_8)
        }
lbl96:
        // 1 sources

        var12_14 = var5_5;
        while (var12_14 <= var6_6) {
            if (var3_3[var12_14] != '*') {
                return false;
            }
            ++var12_14;
        }
        return true;
    }

    public void setBasedir(String string) {
        this.setBasedir(new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setCaseSensitive(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            this.includes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.includes[n] = string;
                ++n;
            }
        }
    }

    public void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (string.endsWith(File.separator)) {
                    string = string + "**";
                }
                this.excludes[n] = string;
                ++n;
            }
        }
    }

    public void scan() {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                this.dirsIncluded.addElement("");
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.scandir(this.basedir, "", true);
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.couldHoldIncluded((String)objectArray[n])) {
                this.scandir(new File(this.basedir, (String)objectArray[n]), (String)objectArray[n] + File.separator, false);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            if (!this.couldHoldIncluded((String)objectArray2[n2])) {
                this.scandir(new File(this.basedir, (String)objectArray2[n2]), (String)objectArray2[n2] + File.separator, false);
            }
            ++n2;
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File file, String string, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new BuildException("IO error scanning directory " + file.getAbsolutePath());
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = string + stringArray[n];
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        this.dirsIncluded.addElement(string2);
                        if (bl) {
                            this.scandir(file2, string2 + File.separator, bl);
                        }
                    } else {
                        this.dirsExcluded.addElement(string2);
                        if (bl && this.couldHoldIncluded(string2)) {
                            this.scandir(file2, string2 + File.separator, bl);
                        }
                    }
                } else {
                    this.dirsNotIncluded.addElement(string2);
                    if (bl && this.couldHoldIncluded(string2)) {
                        this.scandir(file2, string2 + File.separator, bl);
                    }
                }
                if (!bl) {
                    this.scandir(file2, string2 + File.separator, bl);
                }
            } else if (file2.isFile()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        this.filesIncluded.addElement(string2);
                    } else {
                        this.filesExcluded.addElement(string2);
                    }
                } else {
                    this.filesNotIncluded.addElement(string2);
                }
            }
            ++n;
        }
    }

    protected boolean isIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPath(this.includes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String string) {
        int n = 0;
        while (n < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isExcluded(String string) {
        int n = 0;
        while (n < this.excludes.length) {
            if (DirectoryScanner.matchPath(this.excludes[n], string, this.isCaseSensitive)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] getIncludedFiles() {
        int n = this.filesIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.filesIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        int n = this.filesNotIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.filesNotIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        int n = this.filesExcluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.filesExcluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getIncludedDirectories() {
        int n = this.dirsIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.dirsIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        int n = this.dirsNotIncluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.dirsNotIncluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        int n = this.dirsExcluded.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.dirsExcluded.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void addDefaultExcludes() {
        int n = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n + DEFAULTEXCLUDES.length];
        if (n > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n);
        }
        int n2 = 0;
        while (n2 < DEFAULTEXCLUDES.length) {
            stringArray[n2 + n] = DEFAULTEXCLUDES[n2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++n2;
        }
        this.excludes = stringArray;
    }
}

