/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.web;

import java.io.Serializable;
import java.util.Vector;
import org.apache.tools.ant.types.EnumeratedAttribute;
import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.util.Translator;

public class WebXmlSubTask
extends XmlSubTask {
    public static final String SUBTASK_NAME = "deploymentDescriptor";
    private static String DEFAULT_TEMPLATE_FILE = "/xdoclet/web/web_xml.j";
    private static String GENERATED_FILE_NAME = "web.xml";
    private static String WEBXML_PUBLICID_2_3 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    private static String WEBXML_PUBLICID_2_2 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    private static String WEBXML_SYSTEMID_2_3 = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static String WEBXML_SYSTEMID_2_2 = "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    private static String WEBXML_DTD_FILE_NAME_2_3 = "/xdoclet/web/web-jar-23.dtd";
    private static String WEBXML_DTD_FILE_NAME_2_2 = "/xdoclet/web/web-jar-22.dtd";
    protected String servletspec = "2.3";
    protected String smallicon = "";
    protected String largeicon = "";
    protected String displayname = "";
    protected String description = "";
    protected boolean distributable = true;
    protected Vector contextParams = new Vector();
    protected int sessiontimeout = 0;
    protected Vector welcomeFiles = new Vector();
    protected Vector tagLibs = new Vector();

    public WebXmlSubTask() {
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_FILE_NAME);
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public String getServletspec() {
        return this.servletspec;
    }

    public Vector getContextParams() {
        return this.contextParams;
    }

    public String getSmallicon() {
        return this.smallicon;
    }

    public String getLargeicon() {
        return this.largeicon;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public int getSessiontimeout() {
        return this.sessiontimeout;
    }

    public Vector getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public Vector getTagLibs() {
        return this.tagLibs;
    }

    public void setServletspec(ServletVersionTypes new_servletspec) {
        this.servletspec = new_servletspec.getValue();
    }

    public void setSmallicon(String new_icon) {
        this.smallicon = new_icon;
    }

    public void setLargeicon(String new_icon) {
        this.largeicon = new_icon;
    }

    public void setDisplayname(String new_display_name) {
        this.displayname = new_display_name;
    }

    public void setDescription(String new_description) {
        this.description = new_description;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setSessiontimeout(int session_timeout) {
        this.sessiontimeout = session_timeout;
    }

    public void setTagLibs(Vector tagLibs) {
        this.tagLibs = tagLibs;
    }

    public void setWelcomeFiles(Vector welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    public void setContextParams(Vector contextParams) {
        this.contextParams = contextParams;
    }

    public void addContextparam(ContextParam cp) {
        this.contextParams.addElement(cp);
    }

    public void addWelcomefile(WelcomeFile file) {
        this.welcomeFiles.addElement(file);
    }

    public void addTaglib(TagLib taglib) {
        this.tagLibs.addElement(taglib);
    }

    public void execute() throws XDocletException {
        if (this.getServletspec().equals("2.2")) {
            this.setPublicId(WEBXML_PUBLICID_2_2);
            this.setSystemId(WEBXML_SYSTEMID_2_2);
            this.setDtdFileName(WEBXML_DTD_FILE_NAME_2_2);
        } else {
            this.setPublicId(WEBXML_PUBLICID_2_3);
            this.setSystemId(WEBXML_SYSTEMID_2_3);
            this.setDtdFileName(WEBXML_DTD_FILE_NAME_2_3);
        }
        this.startProcess();
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString("generating_something", new String[]{this.getDestinationFile()}));
    }

    public static class ServletVersionTypes
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"2.2", "2.3"};
        }
    }

    public static class WelcomeFile
    implements Serializable {
        private String file = null;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }

    public static class TagLib
    implements Serializable {
        private String taglibUri = null;
        private String taglibLocation = null;

        public String getUri() {
            return this.taglibUri;
        }

        public String getLocation() {
            return this.taglibLocation;
        }

        public void setUri(String uri) {
            this.taglibUri = uri;
        }

        public void setLocation(String location) {
            this.taglibLocation = location;
        }
    }

    public static class ContextParam
    implements Serializable {
        private String paramName = null;
        private String paramValue = null;
        private String description = "";

        public String getName() {
            return this.paramName;
        }

        public String getValue() {
            return this.paramValue;
        }

        public String getDescription() {
            return this.description;
        }

        public void setName(String name) {
            this.paramName = name;
        }

        public void setValue(String value) {
            this.paramValue = value;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }
    }
}

