/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;

public class MethodTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$tags$MethodTagsHandler;

    public static String getMethodTypeFor(MethodDoc method) throws XDocletException {
        return method.returnType().qualifiedTypeName() + method.returnType().dimension();
    }

    public static String getMethodNameWithoutPrefixFor(MethodDoc cur_method) {
        String str = cur_method.name();
        if (str.startsWith("get") || str.startsWith("set")) {
            return str.substring(3);
        }
        if (str.startsWith("is")) {
            return str.substring(2);
        }
        return str;
    }

    public static String getPropertyNameFor(MethodDoc method) {
        String name = MethodTagsHandler.getMethodNameWithoutPrefixFor(method);
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (len == 1) {
            return name.toLowerCase();
        }
        char c = name.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32) + name.substring(1);
        }
        return name;
    }

    public static boolean isGetter(String str) {
        return str.startsWith("get") || str.startsWith("is");
    }

    protected static boolean hasMethod(ClassDoc clazz, String methodName, String[] parameters) {
        Category cat = Log.getCategory(class$xdoclet$tags$MethodTagsHandler == null ? (class$xdoclet$tags$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tags.MethodTagsHandler")) : class$xdoclet$tags$MethodTagsHandler, "hasMethod");
        while (clazz != null) {
            MethodDoc[] methods = clazz.methods();
            int i = 0;
            while (i < methods.length) {
                block5: {
                    if (methods[i].name().equals(methodName)) {
                        Parameter[] params = methods[i].parameters();
                        cat.debug((Object)("params.length=" + params.length));
                        int j = 0;
                        while (j < params.length) {
                            cat.debug((Object)("params[j].typeName()=" + params[j].typeName()));
                            cat.debug((Object)("parameters[j]=" + parameters[j]));
                            if (parameters != null && params[j].typeName().equals(parameters[j])) {
                                ++j;
                                continue;
                            }
                            break block5;
                        }
                        return true;
                    }
                }
                ++i;
            }
            clazz = clazz.superclass();
        }
        return false;
    }

    public String getterPrefix() throws XDocletException {
        String prefix = "";
        if (this.getCurrentMethod().name().startsWith("get")) {
            prefix = "get";
        } else if (this.getCurrentMethod().name().startsWith("is")) {
            prefix = "is";
        } else if (this.getCurrentMethod().name().startsWith("set")) {
            String[] params = new String[]{this.getCurrentMethod().returnType().typeName()};
            if (this.hasMethod(this.getCurrentClass(), "is" + this.methodNameWithoutPrefix(), params, false)) {
                prefix = "is";
            } else {
                prefix = "get";
                return "get";
            }
        }
        return prefix;
    }

    public String getterMethod() throws XDocletException {
        return this.getterPrefix() + this.methodNameWithoutPrefix();
    }

    public String setterMethod() throws XDocletException {
        return "set" + this.methodNameWithoutPrefix();
    }

    public void setCurrentMethod(String template, Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        MethodDoc oldMethod = this.getCurrentMethod();
        if (this.hasMethod(this.getCurrentClass(), methodName, parameters, true)) {
            this.generate(template);
        }
        this.setCurrentMethod(oldMethod);
    }

    public String methodComment(Properties attributes) throws XDocletException {
        String no_comment_signs = attributes.getProperty("no-comment-signs");
        if (no_comment_signs != null && no_comment_signs.equalsIgnoreCase("true")) {
            return this.getCurrentMethod().commentText();
        }
        char[] spaces = this.getIndentChars(attributes);
        Tag[] method_tags = this.getCurrentMethod().tags();
        if (method_tags.length > 0) {
            StringBuffer result = new StringBuffer();
            StringTokenizer st = new StringTokenizer(this.getCurrentMethod().commentText().trim(), "\n", false);
            if (st.countTokens() > 0) {
                result.append(spaces).append("/**").append("\n");
                while (st.hasMoreTokens()) {
                    result.append(spaces).append(" * ").append(st.nextToken().trim()).append("\n");
                }
                int i = 0;
                while (i < method_tags.length) {
                    if (method_tags[i].name().lastIndexOf(58) == -1) {
                        result.append(spaces).append(" * ").append(method_tags[i].name()).append(' ').append(method_tags[i].text());
                        if (i < method_tags.length - 1) {
                            result.append("\n");
                        }
                    }
                    ++i;
                }
                result.append(spaces).append(" */");
            }
            return result.toString();
        }
        return "";
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        String skip_exceptions = attributes.getProperty("skip");
        String append_exceptions = attributes.getProperty("append");
        String method_name = attributes.getProperty("method");
        ClassDoc[] exceptions = null;
        if (this.getCurrentMethod() == null && method_name == null) {
            return "";
        }
        if (method_name == null) {
            exceptions = this.getCurrentMethod().thrownExceptions();
        } else {
            MethodDoc method_doc = this.getMethodDocForMethodName(method_name, true);
            if (method_doc == null) {
                return "";
            }
            exceptions = method_doc.thrownExceptions();
        }
        StringBuffer st = new StringBuffer();
        String type = null;
        int i = 0;
        while (i < exceptions.length) {
            type = exceptions[i].toString();
            if (!this.isInSkipExceptionsList(skip_exceptions, type) && !this.isInAppendExceptionsList(append_exceptions, type)) {
                this.appendException(st, type);
            }
            ++i;
        }
        if (append_exceptions != null) {
            this.appendException(st, append_exceptions);
        }
        return st.toString();
    }

    public void ifIsAbstract(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name == null) {
            if (this.getCurrentMethod().isAbstract()) {
                this.generate(template);
            }
        } else {
            MethodDoc method_doc = this.getMethodDocForMethodName(method_name, false);
            if (method_doc == null) {
                throw new XDocletException(Translator.getString("method_not_found", new String[]{method_name}));
            }
            if (method_doc.isAbstract()) {
                this.generate(template);
            }
        }
    }

    public void ifIsNotAbstract(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name == null) {
            if (!this.getCurrentMethod().isAbstract()) {
                this.generate(template);
            }
        } else {
            MethodDoc method_doc = this.getMethodDocForMethodName(method_name, false);
            if (method_doc == null) {
                throw new XDocletException(Translator.getString("method_not_found", new String[]{method_name}));
            }
            if (!method_doc.isAbstract()) {
                this.generate(template);
            }
        }
    }

    public void forAllClassMethods(String template, Properties attributes) throws XDocletException {
        String type_name = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        ClassDoc[] classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet<MethodDoc> methods = new TreeSet<MethodDoc>();
        int i = 0;
        while (i < classes.length) {
            if (type_name == null || TypeTagsHandler.isOfType((Type)classes[i], type_name, extent)) {
                MethodDoc[] classMethods = classes[i].methods();
                int j = 0;
                while (j < classMethods.length) {
                    methods.add(classMethods[j]);
                    ++j;
                }
            }
            ++i;
        }
        Iterator methodsIterator = methods.iterator();
        while (methodsIterator.hasNext()) {
            MethodDoc current = (MethodDoc)methodsIterator.next();
            this.setCurrentClass(current.containingClass());
            this.setCurrentMethod(current);
            this.generate(template);
        }
    }

    public void forAllMethods(String template, Properties attributes) throws XDocletException {
        boolean superclasses = TypeConversionUtil.stringToBoolean(attributes.getProperty("superclasses"), true);
        boolean sort = TypeConversionUtil.stringToBoolean(attributes.getProperty("sort"), true);
        ClassDoc cur_class = this.getCurrentClass();
        HashMap<MethodDoc, MethodDoc> already = new HashMap<MethodDoc, MethodDoc>();
        do {
            MethodDoc[] methods = cur_class.methods();
            if (sort) {
                List<MethodDoc> the_list = Arrays.asList(methods);
                Collections.sort(the_list, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        MethodDoc m1 = (MethodDoc)o1;
                        MethodDoc m2 = (MethodDoc)o2;
                        return m1.name().compareTo(m2.name());
                    }

                    public boolean equals(Object obj) {
                        return obj == this;
                    }
                });
                methods = the_list.toArray(methods);
            }
            int j = 0;
            while (j < methods.length) {
                if ((!superclasses || superclasses && methods[j].containingClass() == cur_class) && !already.containsKey(methods[j])) {
                    this.setCurrentMethod(methods[j]);
                    already.put(methods[j], methods[j]);
                    this.generate(template);
                }
                ++j;
            }
        } while (superclasses && (cur_class = cur_class.superclass()) != null);
    }

    public void ifDoesntHaveMethodTag(String template, Properties attributes) throws XDocletException {
        if (!this.ifHasTag_Impl(template, attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasMethodTag(String template, Properties attributes) throws XDocletException {
        if (this.ifHasTag_Impl(template, attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreMethod(String template, Properties attributes) throws XDocletException {
        MethodDoc method = this.getCurrentMethod();
        this.generate(template);
        this.setCurrentMethod(method);
    }

    public void ifMethodTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (this.ifTagValueEquals_Impl(template, attributes, 1)) {
            this.generate(template);
        }
    }

    public void ifMethodTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!this.ifTagValueEquals_Impl(template, attributes, 1)) {
            this.generate(template);
        }
    }

    public String methodTagValue(Properties attributes) throws XDocletException {
        return this.getTagValue(attributes, 1);
    }

    public void forAllMethodTags(String template, Properties attributes) throws XDocletException {
        if (this.getCurrentMethod() == null) {
            throw new XDocletException(Translator.getString("only_call_method_not_null", new String[]{"forAllMethodTags"}));
        }
        Tag[] tags = this.getCurrentMethod().tags(attributes.getProperty("tagName"));
        int i = 0;
        while (i < tags.length) {
            this.setCurrentTag(tags[i]);
            String m = this.getTagValue(attributes, 1);
            if (AbstractProgramElementTagsHandler.matchPattern == null) {
                this.generate(template);
            } else if (AbstractProgramElementTagsHandler.matchPattern != null && (AbstractProgramElementTagsHandler.matchPattern.equals(m) || m.equals("*"))) {
                this.generate(template);
            }
            ++i;
        }
        this.setCurrentTag(null);
    }

    public void forAllMethodTagTokens(String template, Properties attributes) throws XDocletException {
        int skip;
        Category cat = Log.getCategory(class$xdoclet$tags$MethodTagsHandler == null ? (class$xdoclet$tags$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tags.MethodTagsHandler")) : class$xdoclet$tags$MethodTagsHandler, "forAllMethodTagTokens");
        String tagValue = this.getTagValue(attributes, 1);
        String delimiter = attributes.getProperty("delimiter");
        String s = attributes.getProperty("skip");
        try {
            skip = Integer.valueOf(attributes.getProperty("skip"));
        }
        catch (Throwable t) {
            skip = 0;
        }
        if (delimiter == null) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"got null delimiter - forAllMethodTagTokens");
            }
            delimiter = ",";
        }
        AbstractProgramElementTagsHandler.tagTokenizer = new StringTokenizer(tagValue, delimiter, false);
        AbstractProgramElementTagsHandler.currentToken = "";
        AbstractProgramElementTagsHandler.matchPattern = null;
        int i = 0;
        while (AbstractProgramElementTagsHandler.tagTokenizer.hasMoreTokens() && i < skip) {
            AbstractProgramElementTagsHandler.tagTokenizer.nextToken();
            ++i;
        }
        while (AbstractProgramElementTagsHandler.tagTokenizer.hasMoreTokens()) {
            AbstractProgramElementTagsHandler.currentToken = AbstractProgramElementTagsHandler.tagTokenizer.nextToken();
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("generate current token: " + AbstractProgramElementTagsHandler.currentToken));
            }
            this.generate(template);
        }
        AbstractProgramElementTagsHandler.currentToken = null;
        AbstractProgramElementTagsHandler.tagTokenizer = null;
        AbstractProgramElementTagsHandler.matchPattern = null;
    }

    public String firstSentenceDescriptionOfCurrentMethod() throws XDocletException {
        return this.getCurrentMethod().firstSentenceTags().length > 0 ? this.getCurrentMethod().firstSentenceTags()[0].text().trim() : "";
    }

    public String methodType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor(this.getCurrentMethod());
    }

    public String methodName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)((Hashtable)attributes).get("value")) != null) {
            String m = this.getCurrentMethod().name().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return this.getCurrentMethod() != null ? this.getCurrentMethod().name() : "";
    }

    public String methodNameWithoutPrefix() throws XDocletException {
        return MethodTagsHandler.getMethodNameWithoutPrefixFor(this.getCurrentMethod());
    }

    public String currentMethodName() throws XDocletException {
        return this.getCurrentMethod().name();
    }

    public String propertyName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(this.getCurrentMethod());
    }

    public void ifHasMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, true);
    }

    public void ifDoesntHaveMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, false);
    }

    protected MethodDoc getMethodDocForMethodName(String methodName) {
        if (methodName != null) {
            return this.extractMethodDoc(this.getCurrentClass(), methodName);
        }
        return null;
    }

    protected MethodDoc getMethodDocForMethodName(String methodName, boolean superclasses) {
        if (!superclasses) {
            return this.getMethodDocForMethodName(methodName);
        }
        ClassDoc clazz = this.getCurrentClass();
        while (clazz != null) {
            MethodDoc method = this.extractMethodDoc(clazz, methodName);
            if (method != null) {
                return method;
            }
            clazz = clazz.superclass();
        }
        return null;
    }

    protected boolean hasMethod(ClassDoc clazz, String methodName, String[] parameters, boolean setCurrentMethod) {
        Category cat = Log.getCategory(class$xdoclet$tags$MethodTagsHandler == null ? (class$xdoclet$tags$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tags.MethodTagsHandler")) : class$xdoclet$tags$MethodTagsHandler, "hasMethod");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("Search for method " + methodName + " in " + clazz.name()));
        }
        while (clazz != null) {
            MethodDoc[] methods = clazz.methods();
            int i = 0;
            while (i < methods.length) {
                block14: {
                    if (methods[i].name().equals(methodName)) {
                        Parameter[] params = methods[i].parameters();
                        if (parameters == null) {
                            if (setCurrentMethod) {
                                this.setCurrentMethod(methods[i]);
                            }
                            return true;
                        }
                        if ((parameters == null || params != null) && parameters.length == params.length) {
                            int j = 0;
                            while (j < params.length) {
                                if (params[j].typeName().equals(parameters[j])) {
                                    ++j;
                                    continue;
                                }
                                break block14;
                            }
                            int j2 = 0;
                            while (j2 < parameters.length) {
                                if (params[j2].typeName().equals(parameters[j2])) {
                                    ++j2;
                                    continue;
                                }
                                break block14;
                            }
                            if (cat.isDebugEnabled()) {
                                cat.debug((Object)("Method found in " + clazz.name()));
                            }
                            if (setCurrentMethod) {
                                this.setCurrentMethod(methods[i]);
                            }
                            return true;
                        }
                    }
                }
                ++i;
            }
            clazz = clazz.superclass();
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)"Method not found");
        }
        return false;
    }

    private boolean isInAppendExceptionsList(String append_exceptions, String type) {
        if (append_exceptions == null) {
            return false;
        }
        return append_exceptions.indexOf(type) != -1;
    }

    private boolean isInSkipExceptionsList(String skip_exceptions, String type) {
        if (skip_exceptions == null) {
            return false;
        }
        return skip_exceptions.indexOf(type) != -1;
    }

    private MethodDoc extractMethodDoc(ClassDoc clazz, String methodName) {
        MethodDoc[] methods = clazz.methods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].name().equals(methodName)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private void appendException(StringBuffer st, String type) {
        if (st.length() == 0) {
            st.append("throws ");
        } else {
            st.append(", ");
        }
        st.append(type);
    }

    private void ifHasMethod_Impl(String template, Properties attributes, boolean has_method) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$MethodTagsHandler == null ? (class$xdoclet$tags$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tags.MethodTagsHandler")) : class$xdoclet$tags$MethodTagsHandler, "ifHasMethod_Impl");
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("methodName=" + methodName));
            cat.debug((Object)("parametersStr=" + parametersStr));
            cat.debug((Object)("delimiter=" + delimiter));
            cat.debug((Object)("has_method=" + has_method));
            cat.debug((Object)("getCurrentClass()=" + this.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("parameters.length=" + parameters.length));
                cat.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (this.hasMethod(this.getCurrentClass(), methodName, parameters, false) == has_method) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"method found.");
            }
            this.generate(template);
        } else if (cat.isDebugEnabled()) {
            cat.debug((Object)"method not found.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

