/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Tag;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.ejb.tags.EjbTagsHandler;
import xdoclet.tags.MethodTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public class RelationTagsHandler
extends EjbTagsHandler {
    protected static Map relationMap = new HashMap();
    protected static RelationHolder currentRelation;
    static /* synthetic */ Class class$xdoclet$ejb$tags$RelationTagsHandler;

    public void ifLeftCascadeDelete(String template) throws XDocletException {
        String cd = XDocletTagSupport.getMethodTagValue(currentRelation.getLeftMethod(), "ejb:relation", "cascade-delete", 0, "yes,no", "no", false);
        if ("yes".equals(cd)) {
            this.generate(template);
        }
    }

    public void ifRightCascadeDelete(String template) throws XDocletException {
        String cd = null;
        cd = this.isBidirectional() ? XDocletTagSupport.getMethodTagValue(currentRelation.getRightMethod(), "ejb:relation", "cascade-delete", 0, "yes,no", "no", false) : XDocletTagSupport.getMethodTagValue(currentRelation.getLeftMethod(), "ejb:relation", "target-cascade-delete", 0, "yes,no", "no", false);
        if ("yes".equals(cd)) {
            this.generate(template);
        }
    }

    public String leftEJBName() throws XDocletException {
        return EjbTagsHandler.getEjbNameFor(currentRelation.getLeft());
    }

    public String rightEJBName() throws XDocletException {
        if (this.isBidirectional()) {
            return EjbTagsHandler.getEjbNameFor(currentRelation.getRight());
        }
        return XDocletTagSupport.getMethodTagValue(currentRelation.getLeftMethod(), "ejb:relation", "target-ejb", 0, null, null, true);
    }

    public void ifHasRelationships(String template) throws XDocletException {
        ClassDoc[] classes = this.getContext().getRoot().classes();
        boolean hasRelationships = false;
        int i = 0;
        while (i < classes.length) {
            this.setCurrentClass(classes[i]);
            MethodDoc[] methods = classes[i].methods();
            int j = 0;
            while (j < methods.length) {
                this.setCurrentMethod(methods[j]);
                Tag[] relation = DocletUtil.getTagsByName(methods[j], "ejb:relation");
                if (relation != null && relation.length > 0) {
                    hasRelationships = true;
                    break;
                }
                ++j;
            }
            if (hasRelationships) break;
            ++i;
        }
        if (hasRelationships) {
            this.generate(template);
        }
    }

    public String relationName() throws XDocletException {
        return currentRelation.getName();
    }

    public void forAllRelationships(String template) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$ejb$tags$RelationTagsHandler == null ? (class$xdoclet$ejb$tags$RelationTagsHandler = RelationTagsHandler.class$("xdoclet.ejb.tags.RelationTagsHandler")) : class$xdoclet$ejb$tags$RelationTagsHandler, "forAllRelationships");
        ClassDoc[] classes = this.getContext().getRoot().classes();
        relationMap.clear();
        int i = 0;
        while (i < classes.length) {
            this.setCurrentClass(classes[i]);
            MethodDoc[] methods = classes[i].methods();
            int j = 0;
            while (j < methods.length) {
                this.setCurrentMethod(methods[j]);
                Tag[] relationTags = DocletUtil.getTagsByName(methods[j], "ejb:relation");
                if (relationTags.length > 1) {
                    throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "multiple_relations", new String[]{classes[i] + "." + methods[j]}));
                }
                if (relationTags.length == 1) {
                    String relationName = this.getParameterValue(relationTags[0].text(), "name", 0);
                    if (relationName == null) {
                        throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "relation_must_have_name", new String[]{this.getCurrentClass().name()}));
                    }
                    RelationHolder relationHolder = (RelationHolder)relationMap.get(relationName);
                    if (relationHolder != null && relationHolder.getLeft() != null && relationHolder.getRight() != null) {
                        throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "relation_too_many_names", new String[]{this.getCurrentClass().name()}));
                    }
                    if (relationHolder == null) {
                        if (cat.isDebugEnabled()) {
                            cat.debug((Object)("Created new relationship for " + classes[i] + "." + methods[j]));
                        }
                        relationHolder = new RelationHolder();
                        relationHolder.left = classes[i];
                        relationHolder.leftMethod = methods[j];
                        relationHolder.right = null;
                        relationMap.put(relationName, relationHolder);
                    } else {
                        if (cat.isDebugEnabled()) {
                            cat.debug((Object)("Added " + classes[i] + " to relationship: " + relationHolder));
                        }
                        if (!this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor(relationHolder.leftMethod)) && this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor(methods[j]))) {
                            if (cat.isDebugEnabled()) {
                                cat.debug((Object)"Swapping left -> right in attempt to make 1-n be 1-n (rather than n-1)");
                            }
                            relationHolder.right = relationHolder.left;
                            relationHolder.rightMethod = relationHolder.leftMethod;
                            relationHolder.left = classes[i];
                            relationHolder.leftMethod = methods[j];
                        } else {
                            relationHolder.right = classes[i];
                            relationHolder.rightMethod = methods[j];
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        Iterator relationNameIterator = relationMap.keySet().iterator();
        while (relationNameIterator.hasNext()) {
            String relationName = (String)relationNameIterator.next();
            RelationHolder relationHolder = (RelationHolder)relationMap.get(relationName);
            this.setCurrentClass(relationHolder.getLeft());
            this.setCurrentMethod(relationHolder.getLeftMethod());
            currentRelation = relationHolder;
            Tag[] relationTags = DocletUtil.getTagsByName(relationHolder.getLeftMethod(), "ejb:relation");
            String target = this.getParameterValue(relationTags[0].text(), "target-ejb", 0);
            if (relationHolder.getRight() == null) {
                if (target == null) {
                    throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "relation_needs_target", new String[]{relationName, relationHolder.getLeft().name() + "." + relationHolder.getLeftMethod().name()}));
                }
            } else if (target != null) {
                throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "relation_needs_no_target", new String[]{relationName, relationHolder.getLeft().name() + "." + relationHolder.getLeftMethod().name()}));
            }
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("Generating template for Relation: " + currentRelation));
            }
            this.generate(template);
        }
    }

    public void ifIsLeftMany(String template) throws XDocletException {
        if (currentRelation.isLeftMany()) {
            this.generate(template);
        }
    }

    public void ifIsRightMany(String template) throws XDocletException {
        if (currentRelation.isRightMany()) {
            this.generate(template);
        }
    }

    public String leftFieldName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(currentRelation.getLeftMethod());
    }

    public String rightFieldName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(currentRelation.getRightMethod());
    }

    public String leftFieldType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor(currentRelation.getLeftMethod());
    }

    public String rightFieldType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor(currentRelation.getRightMethod());
    }

    public void ifIsNotACollection(String template) throws XDocletException {
        if (!this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor(this.getCurrentMethod()))) {
            this.generate(template);
        }
    }

    public String relationComment() {
        return "<!-- " + currentRelation.toString() + " -->";
    }

    public void ifIsOne2One(String template) throws XDocletException {
        if (this.isOne2One()) {
            this.generate(template);
        }
    }

    public void ifNotIsOne2One(String template) throws XDocletException {
        if (!this.isOne2One()) {
            this.generate(template);
        }
    }

    public void ifIsOne2Many(String template) throws XDocletException {
        if (this.isOne2Many()) {
            this.generate(template);
        }
    }

    public void ifNotIsOne2Many(String template) throws XDocletException {
        if (!this.isOne2Many()) {
            this.generate(template);
        }
    }

    public void ifIsMany2Many(String template) throws XDocletException {
        if (this.isMany2Many()) {
            this.generate(template);
        }
    }

    public void ifNotIsMany2Many(String template) throws XDocletException {
        if (!this.isMany2Many()) {
            this.generate(template);
        }
    }

    public void ifIsBidirectional(String template) throws XDocletException {
        if (this.isBidirectional()) {
            this.generate(template);
        }
    }

    public void ifIsUnidirectional(String template) throws XDocletException {
        if (!this.isBidirectional()) {
            this.generate(template);
        }
    }

    public void ifHasLeftRoleName(String template) throws XDocletException {
        if (this.leftRoleName() != null) {
            this.generate(template);
        }
    }

    public void ifHasRightRoleName(String template) throws XDocletException {
        if (this.rightRoleName() != null) {
            this.generate(template);
        }
    }

    public String leftRoleName() throws XDocletException {
        return currentRelation.getLeftRoleName();
    }

    public String rightRoleName() throws XDocletException {
        return currentRelation.getRightRoleName();
    }

    public String leftMultiplicity() throws XDocletException {
        return currentRelation.getLeftMultiplicity();
    }

    public String rightMultiplicity() throws XDocletException {
        return currentRelation.getRightMultiplicity();
    }

    protected boolean isSetOrCollection(String type) {
        return type.equals("java.util.Collection") || type.equals("java.util.Set");
    }

    protected boolean isMany2Many() throws XDocletException {
        return currentRelation.isMany2Many();
    }

    protected boolean isOne2One() throws XDocletException {
        return currentRelation.isOne2One();
    }

    protected boolean isOne2Many() throws XDocletException {
        return currentRelation.isOne2Many();
    }

    protected boolean isBidirectional() throws XDocletException {
        return currentRelation.isBidirectional();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RelationHolder {
        private static final String ONE = "One";
        private static final String MANY = "Many";
        private ClassDoc left;
        private MethodDoc leftMethod;
        private ClassDoc right;
        private MethodDoc rightMethod;

        public boolean isBidirectional() {
            return this.getRightMethod() != null;
        }

        public boolean isOne2One() throws XDocletException {
            return !this.isLeftMany() && !this.isRightMany();
        }

        public boolean isOne2Many() throws XDocletException {
            return !this.isLeftMany() && this.isRightMany();
        }

        public boolean isMany2Many() throws XDocletException {
            return this.isLeftMany() && this.isRightMany();
        }

        public String getLeftMultiplicity() throws XDocletException {
            return this.isLeftMany() ? MANY : ONE;
        }

        public String getRightMultiplicity() throws XDocletException {
            return this.isRightMany() ? MANY : ONE;
        }

        public ClassDoc getLeft() {
            return this.left;
        }

        public MethodDoc getLeftMethod() {
            return this.leftMethod;
        }

        public ClassDoc getRight() {
            return this.right;
        }

        public MethodDoc getRightMethod() {
            return this.rightMethod;
        }

        public String getLeftRoleName() throws XDocletException {
            return RelationTagsHandler.super.getParameterValue(DocletUtil.getText((Doc)this.getLeftMethod(), "ejb:relation"), "role-name", -1);
        }

        public String getRightRoleName() throws XDocletException {
            if (this.isBidirectional()) {
                return RelationTagsHandler.super.getParameterValue(DocletUtil.getText((Doc)this.getRightMethod(), "ejb:relation"), "role-name", -1);
            }
            return RelationTagsHandler.super.getParameterValue(DocletUtil.getText((Doc)this.getLeftMethod(), "ejb:relation"), "target-role-name", -1);
        }

        public boolean isLeftMany() throws XDocletException {
            return RelationTagsHandler.this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor(this.getLeftMethod()));
        }

        public boolean isRightMany() throws XDocletException {
            boolean result;
            if (this.getRightMethod() != null) {
                result = RelationTagsHandler.this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor(this.getRightMethod()));
            } else {
                String targetMultiple = RelationTagsHandler.super.getParameterValue(DocletUtil.getText((Doc)this.getLeftMethod(), "ejb:relation"), "target-multiple", -1);
                result = "yes".equals(targetMultiple);
            }
            return result;
        }

        public String getName() throws XDocletException {
            return RelationTagsHandler.super.getParameterValue(DocletUtil.getText((Doc)this.getLeftMethod(), "ejb:relation"), "name", -1);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.getLeft().hashCode();
            result = 37 * result + this.getLeftMethod().hashCode();
            if (this.getRight() != null) {
                result = 37 * result + this.getRight().hashCode();
            }
            if (this.getRightMethod() != null) {
                result = 37 * result + this.getRightMethod().hashCode();
            }
            return result;
        }

        public String toString() {
            return "RelationHolder left=" + this.getLeft() + '.' + this.getLeftMethod() + " right=" + this.getRight() + '.' + this.getRightMethod();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationHolder)) {
                return false;
            }
            RelationHolder other = this;
            if (this.getLeft() == null) {
                if (other.getLeft() != null) return false;
                bl3 = true;
            } else {
                bl3 = this.getLeft().equals(other.getLeft());
            }
            if (!bl3) return false;
            if (this.getLeftMethod() == null) {
                if (other.getLeftMethod() != null) return false;
                bl2 = true;
            } else {
                bl2 = this.getLeftMethod().equals(other.getLeftMethod());
            }
            if (!bl2) return false;
            if (this.getRight() == null) {
                if (other.getRight() != null) return false;
                bl = true;
            } else {
                bl = this.getRight().equals(other.getRight());
            }
            if (!bl) return false;
            if (this.getRightMethod() == null) {
                if (other.getRightMethod() != null) return false;
                return true;
            }
            boolean bl4 = this.getRightMethod().equals(other.getRightMethod());
            if (!bl4) return false;
            return true;
        }
    }
}

