/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLPrinter
extends AbstractComponent
implements Printer {
    @Override
    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        this.printDocument(document, new PrintStream(outputStream), 0);
    }

    private void printNodeList(NodeList nodeList, PrintStream printStream, int n) {
        block14: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 2: {
                    this.printAttribute((Attr)node, printStream, n);
                    continue block14;
                }
                case 4: {
                    this.printCDATASection((CDATASection)node, printStream, n);
                    continue block14;
                }
                case 8: {
                    this.printComment((Comment)node, printStream, n);
                    continue block14;
                }
                case 11: {
                    this.printDocumentFragment((DocumentFragment)node, printStream, n);
                    continue block14;
                }
                case 9: {
                    this.printDocument((Document)node, printStream, n);
                    continue block14;
                }
                case 10: {
                    this.printDocumentType((DocumentType)node, printStream, n);
                    continue block14;
                }
                case 1: {
                    this.printElement((Element)node, printStream, n);
                    continue block14;
                }
                case 6: {
                    this.printEntity((Entity)node, printStream, n);
                    continue block14;
                }
                case 5: {
                    this.printEntityReference((EntityReference)node, printStream, n);
                    continue block14;
                }
                case 12: {
                    this.printNotation((Notation)node, printStream, n);
                    continue block14;
                }
                case 7: {
                    this.printProcessingInstruction((ProcessingInstruction)node, printStream, n);
                    continue block14;
                }
                case 3: {
                    this.printText((Text)node, printStream, n);
                }
            }
        }
    }

    private void printAttribute(Attr attr, PrintStream printStream, int n) {
        printStream.print(attr.getName() + "=\"" + attr.getValue() + "\"");
    }

    private void printCDATASection(CDATASection cDATASection, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<[CDATA[" + cDATASection.getData() + "]]>");
    }

    private void printComment(Comment comment, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!--" + comment.getData() + "-->");
    }

    private void printDocumentFragment(DocumentFragment documentFragment, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Document Fragment Node -->");
    }

    private void printDocument(Document document, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<?xml version=\"1.0\"?>");
        this.printNodeList(document.getChildNodes(), printStream, n);
    }

    private void printDocumentType(DocumentType documentType, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!DOCTYPE " + documentType.getName() + ">");
    }

    private void printElement(Element element, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.print("<" + element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (null != namedNodeMap && namedNodeMap.getLength() > 0) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                printStream.print(' ');
                this.printAttribute((Attr)namedNodeMap.item(i), printStream, n);
            }
        }
        if (null != element.getChildNodes() && element.getChildNodes().getLength() > 0) {
            printStream.println(">");
            this.printNodeList(element.getChildNodes(), printStream, n + 1);
            this.indent(printStream, n);
            printStream.println("</" + element.getTagName() + ">");
        } else {
            printStream.println("/>");
        }
    }

    private void printEntity(Entity entity, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Entity Node -->");
    }

    private void printEntityReference(EntityReference entityReference, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Entity Reference Node -->");
    }

    private void printNotation(Notation notation, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<!-- Notation Node -->");
    }

    private void printProcessingInstruction(ProcessingInstruction processingInstruction, PrintStream printStream, int n) {
        this.indent(printStream, n);
        printStream.println("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
    }

    private void printText(Text text, PrintStream printStream, int n) {
        Node node;
        String string = text.getData();
        if (string.length() == 0) {
            return;
        }
        if ((string = this.leftTrim(string)).length() == 0) {
            return;
        }
        Text text2 = text;
        while ((node = text2.getNextSibling()) != null && node.getNodeType() == 3) {
            Text text3 = (Text)node;
            String string2 = text3.getData();
            if (string2.length() > 0) {
                string = Character.isWhitespace(string2.charAt(0)) ? this.trim(string) + ' ' + this.leftTrim(string2) : this.trim(string) + this.leftTrim(string2);
            }
            text3.setData("");
            text2 = text3;
        }
        string = this.trim(string);
        text.setData(string);
        if (string.length() > 0) {
            this.indent(printStream, n);
            printStream.println(string);
        }
    }

    private String leftTrim(String string) {
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        for (int i = 0; i < string.length() && Character.isWhitespace(string.charAt(i)); ++i) {
            n = i + 1;
        }
        if (n == string.length()) {
            return "";
        }
        return string.substring(n);
    }

    private String rightTrim(String string) {
        if (string.length() == 0) {
            return string;
        }
        int n = string.length();
        int n2 = n - 1;
        while (n2 >= 0 && Character.isWhitespace(string.charAt(n2))) {
            n = n2--;
        }
        return string.substring(0, n);
    }

    private String trim(String string) {
        return this.leftTrim(this.rightTrim(string));
    }

    private void indent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
    }
}

