/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImagePrinter
extends AbstractComponent
implements Printer {
    int R = 0;
    int G = 1;
    int B = 2;
    int A = 3;

    @Override
    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        int n;
        Object object;
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("image")) {
            throw new CreationException("Invalid document supplied", document);
        }
        String string = element.getAttribute("source");
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        if (string.length() > 0) {
            object = null;
            object = string.indexOf(":/") >= 0 ? new ImageIcon(new URL(string).openConnection().getURL()) : new ImageIcon(string);
            if (((ImageIcon)object).getIconWidth() < 1 | ((ImageIcon)object).getIconHeight() < 1) {
                throw new CreationException("Cannot load image \"" + string + "\"");
            }
            bufferedImage = new BufferedImage(((ImageIcon)object).getIconWidth(), ((ImageIcon)object).getIconHeight(), 1);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(((ImageIcon)object).getImage(), 0, 0, ((ImageIcon)object).getImageObserver());
        } else {
            Object object2;
            int n2 = 0;
            n = 0;
            try {
                String string2 = element.getAttribute("width");
                object2 = element.getAttribute("height");
                n2 = Integer.parseInt(string2);
                n = Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CreationException("Image witdth or height error");
            }
            if (n2 < 1 | n < 1) {
                throw new CreationException("Image witdth or height unspecified");
            }
            bufferedImage = new BufferedImage(n2, n, 1);
            graphics2D = bufferedImage.createGraphics();
            int n3 = 0;
            try {
                object2 = element.getAttribute("bgcolor");
                n3 = Integer.parseInt((String)object2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CreationException("Background color error");
            }
            object2 = new Color(n3);
            graphics2D.setBackground((Color)object2);
            graphics2D.clearRect(0, 0, n2, n);
            String string3 = element.getAttribute("background");
            if (string3.length() > 0) {
                ImageIcon imageIcon = new ImageIcon(string3);
                if (imageIcon.getIconWidth() < 1 | imageIcon.getIconHeight() < 1) {
                    throw new CreationException("Cannot load background \"" + string + "\"");
                }
                int n4 = 0;
                int n5 = 0;
                do {
                    graphics2D.drawImage(imageIcon.getImage(), n4, n5, imageIcon.getImageObserver());
                    if ((n4 += imageIcon.getIconWidth()) <= n2) continue;
                    n4 = 0;
                    n5 += imageIcon.getIconHeight();
                } while (n5 <= n);
            }
        }
        object = element.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            if (object.item(n).getNodeType() != 1) continue;
            this.processElement((Element)object.item(n), bufferedImage);
        }
        JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        jPEGEncodeParam.setQuality(1.0f, true);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream, (JPEGEncodeParam)jPEGEncodeParam);
        jPEGImageEncoder.encode(bufferedImage);
        outputStream.flush();
    }

    void processElement(Element element, BufferedImage bufferedImage) throws CreationException {
        int n;
        if (element == null) {
            return;
        }
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n6, n7, 2);
        int[] nArray = new int[]{0, 0, 0, 0};
        WritableRaster writableRaster = bufferedImage2.getRaster();
        for (n = 0; n < writableRaster.getWidth(); ++n) {
            for (int i = 10; i < writableRaster.getHeight(); ++i) {
                writableRaster.setPixel(n, i, nArray);
            }
        }
        n = 0;
        if (element.getTagName().equals("text")) {
            n = this.placeText(element, bufferedImage2) ? 1 : 0;
        }
        if (n == 0) {
            return;
        }
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < writableRaster2.getWidth(); ++i) {
            for (int j = 0; j < writableRaster2.getHeight(); ++j) {
                writableRaster2.getPixel(i, j, nArray2);
                writableRaster.getPixel(i, j, nArray);
                if (nArray[n5] > 0) {
                    d2 = (double)nArray[n5] / 255.0;
                    d = 1.0 - d2;
                    nArray2[n2] = (int)((double)nArray2[n2] * d + (double)nArray[n2] * d2);
                    nArray2[n3] = (int)((double)nArray2[n3] * d + (double)nArray[n3] * d2);
                    nArray2[n4] = (int)((double)nArray2[n4] * d + (double)nArray[n4] * d2);
                }
                writableRaster2.setPixel(i, j, nArray2);
            }
        }
    }

    private boolean placeText(Element element, BufferedImage bufferedImage) throws CreationException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string = element.getAttribute("text");
        String string2 = element.getAttribute("font");
        String string3 = element.getAttribute("size");
        String string4 = element.getAttribute("style");
        String string5 = element.getAttribute("color");
        String string6 = element.getAttribute("x");
        String string7 = element.getAttribute("y");
        String string8 = element.getAttribute("halign");
        String string9 = element.getAttribute("valign");
        if (string.length() < 1) {
            return false;
        }
        try {
            n5 = Integer.parseInt(string3);
            n4 = Integer.parseInt(string6);
            n3 = Integer.parseInt(string7);
            n2 = Integer.parseInt(string5, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreationException("Attribute size, x, y or color error");
        }
        int n6 = 0;
        if (string4.equals("bold")) {
            n6 = 1;
        } else if (string4.equals("italic")) {
            n6 = 2;
        } else if (string4.equals("bolditalic")) {
            n6 = 3;
        }
        Font font = new Font(string2, n6, n5);
        FontMetrics fontMetrics = bufferedImage.createGraphics().getFontMetrics(font);
        int n7 = fontMetrics.stringWidth(string) * 2;
        int n8 = fontMetrics.getHeight() * 2;
        BufferedImage bufferedImage2 = new BufferedImage(n7, n8, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(new Color(-16777216, true));
        graphics2D.setFont(font);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(string, 5, n8 - n8 / 4);
        int n9 = n7;
        int n10 = n8;
        int n11 = 0;
        int n12 = 0;
        WritableRaster writableRaster = bufferedImage2.getRaster();
        int[] nArray = new int[]{0, 0, 0, 0};
        for (int i = 0; i < writableRaster.getWidth(); ++i) {
            for (n = 10; n < writableRaster.getHeight(); ++n) {
                writableRaster.getPixel(i, n, nArray);
                if (nArray[this.A] <= 0) continue;
                if (i < n9) {
                    n9 = i;
                }
                if (i > n11) {
                    n11 = i;
                }
                if (n < n10) {
                    n10 = n;
                }
                if (n <= n12) continue;
                n12 = n;
            }
        }
        if (string8.equals("right")) {
            n4 -= n11 - n9 + 1;
        }
        if (string8.equals("center")) {
            n4 -= (n11 - n9 + 1) / 2;
        }
        if (string9.equals("bottom")) {
            n3 -= n12 - n10 + 1;
        }
        if (string9.equals("center")) {
            n3 -= (n12 - n10 + 1) / 2;
        }
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n13 = n3;
        for (int i = n10; i <= n12; ++i) {
            n = n4;
            if (n13 >= 0) {
                for (int j = n9; j <= n11; ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    nArray[this.R] = n2 >> 16 & 0xFF;
                    nArray[this.G] = n2 >> 8 & 0xFF;
                    nArray[this.B] = n2 & 0xFF;
                    if (n >= 0) {
                        writableRaster2.setPixel(n, n13, nArray);
                    }
                    if (++n >= bufferedImage.getWidth()) break;
                }
            }
            if (++n13 >= bufferedImage.getHeight()) break;
        }
        return true;
    }
}

