/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.parsers;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Parser;
import org.apache.stylebook.parsers.AbstractParser;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class XercesParser
extends AbstractParser
implements Parser,
ErrorHandler {
    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();

    public XercesParser() {
        this.docFactory.setNamespaceAware(true);
        this.docFactory.setExpandEntityReferences(true);
    }

    @Override
    public Document parse(InputSource inputSource) throws IOException, CreationException {
        this.debug("Parsing \"" + inputSource.getSystemId() + "\"");
        try {
            DocumentBuilder documentBuilder = this.docFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            if (document == null) {
                throw new CreationException("Cannot retrieve parsed document");
            }
            return document;
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
            throw new CreationException("IOException caught while using DocumentBuilder to parse an XML document.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.log(parserConfigurationException.getMessage());
            throw new CreationException("ParserConfigurationException caught while using DocumentBuilder to parse an XML document.", parserConfigurationException);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            this.log(sAXNotRecognizedException.getMessage());
            throw new CreationException("SAXNotRecognizedException caught while using DocumentBuilder to parse an XML document.", sAXNotRecognizedException);
        }
        catch (SAXException sAXException) {
            this.log(sAXException.getMessage());
            throw new CreationException("SAXException caught using DocumentBuilder to parse an XML document.", sAXException);
        }
    }

    @Override
    public Document create() {
        this.debug("Creating new Document");
        return new DocumentImpl();
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException.getMessage() + " [File: \"" + sAXParseException.getSystemId() + "\" Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + "]", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException.getMessage() + " [File: \"" + sAXParseException.getSystemId() + "\" Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + "]", sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(sAXParseException.getMessage() + " [File: \"" + sAXParseException.getSystemId() + "\" Line: " + sAXParseException.getLineNumber() + " Column: " + sAXParseException.getColumnNumber() + "]", sAXParseException);
    }
}

