/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.stylebook.BasicEngine;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.InitializationException;
import org.apache.stylebook.Loader;
import org.apache.stylebook.LoadingException;
import org.apache.stylebook.Logger;
import org.apache.stylebook.Project;
import org.apache.stylebook.StreamHandler;
import org.apache.stylebook.URLHandler;

public class StyleBook
implements Logger {
    private URL project = null;
    private Properties properties = null;
    private String propertiesfile = "org/apache/stylebook/data/stylebook.properties";

    private StyleBook() {
    }

    private StyleBook(String[] stringArray) throws IOException {
        Object object;
        this.properties = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.propertiesfile);
        this.properties.load(inputStream);
        String string = null;
        Object object2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            int n = ((String)object).indexOf(61);
            if (n < 0) {
                if (string != null) {
                    if (object2 != null) {
                        StyleBook.exit("Duplicate Style (\"" + (String)object2 + "\",\"" + (String)object + "\")", 1);
                        continue;
                    }
                    object2 = object;
                    continue;
                }
                string = object;
                continue;
            }
            String string2 = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1);
            String string4 = (String)this.properties.setProperty(string2, string3);
            StyleBook.log("Overriding " + string2 + "=\"" + string3 + "\" (Old=\"" + string4 + "\")");
        }
        if (string == null) {
            StyleBook.exit("Project file non specified", 1);
        }
        if (object2 == null) {
            StyleBook.exit("Style file non specified", 1);
        }
        File file = new File(string);
        object = new File((String)object2);
        URLHandler uRLHandler = new URLHandler(file, (File)object);
        URL.setURLStreamHandlerFactory(uRLHandler);
        this.project = new URL("sbk:/sources/" + file.getName());
        StyleBook.log("Project URL: \"" + this.project + "\"");
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            Project project;
            StyleBook styleBook = new StyleBook(stringArray);
            Engine engine = styleBook.getEngine();
            if (engine == null) {
                StyleBook.exit("Error creating engine", 3);
            }
            if ((project = styleBook.getProject(engine)) == null) {
                StyleBook.exit("Error creating project", 3);
            }
            String string = styleBook.properties.getProperty("targetDirectory");
            StreamHandler streamHandler = new StreamHandler(string);
            Enumeration enumeration = project.getEntryNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                project.create(string2, streamHandler.getOutputStream(string2));
            }
        }
        catch (CreationException creationException) {
            Exception exception = creationException.getException();
            if (exception != null) {
                StyleBook.log(exception);
            }
            StyleBook.exit(creationException, 255);
        }
        catch (Exception exception) {
            StyleBook.exit(exception, 255);
        }
        StyleBook.exit("All done successfully", 0);
    }

    private Engine getEngine() throws IOException {
        try {
            String string = this.properties.getProperty("parserClass");
            URL uRL = new URL(this.properties.getProperty("engineConfig"));
            return new BasicEngine(string, uRL, this);
        }
        catch (InitializationException initializationException) {
            StyleBook.log(initializationException);
            return null;
        }
    }

    private Project getProject(Engine engine) throws IOException {
        try {
            Loader loader = new Loader(engine);
            URL uRL = new URL(this.properties.getProperty("loaderConfig"));
            return loader.load(uRL, this.project);
        }
        catch (LoadingException loadingException) {
            StyleBook.log(loadingException);
            return null;
        }
    }

    @Override
    public void log(Object object, String string) {
        String string2 = object.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        System.out.println("[" + string2 + "] " + string);
    }

    private static void log(String string) {
        System.out.println("[StyleBook] " + string);
    }

    private static void log(Exception exception) {
        StyleBook.log("Caught " + exception.getClass().getName());
        exception.printStackTrace(System.out);
    }

    private static void exit(String string, int n) {
        StyleBook.log(string);
        System.exit(n);
    }

    private static void exit(Exception exception, int n) {
        StyleBook.log(exception);
        System.exit(n);
    }
}

