/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.stylebook.BasicContext;
import org.apache.stylebook.BasicEntry;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.Entry;
import org.apache.stylebook.LoadingException;
import org.apache.stylebook.NodeListParameters;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Processor;
import org.apache.stylebook.Producer;
import org.apache.stylebook.ResourceEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Project {
    private Hashtable entries = new Hashtable();
    private Engine engine = null;
    private URL urlbase = null;

    public Project(Engine engine, Document document, Parameters parameters, URL uRL) throws LoadingException, IOException {
        this.engine = engine;
        this.urlbase = uRL;
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("project")) {
            throw new LoadingException("Project does not start with <project>");
        }
        NodeList nodeList = element.getChildNodes();
        Parameters parameters2 = new NodeListParameters(nodeList).merge(parameters);
        this.processNodeList(nodeList, this.urlbase, parameters2);
    }

    private void processNodeList(NodeList nodeList, URL uRL, Parameters parameters) throws LoadingException, IOException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            String string;
            if (nodeList.item(i).getNodeType() != 1 || (string = (element = (Element)nodeList.item(i)).getTagName()).equals("parameter")) continue;
            if (string.equals("create")) {
                this.setCreateEntry(element, uRL, parameters);
                continue;
            }
            if (string.equals("resource")) {
                this.setResourceEntry(element, uRL);
                continue;
            }
            if (string.equals("process")) {
                this.processEntry(element, uRL, parameters);
                continue;
            }
            throw new LoadingException("Invalid element <" + string + ">");
        }
    }

    public Enumeration getEntryNames() {
        return this.entries.keys();
    }

    public void create(String string, OutputStream outputStream) throws IOException, CreationException {
        this.engine.log(this, "Creating \"" + string + "\"");
        Entry entry = (Entry)this.entries.get(string);
        if (entry == null) {
            throw new CreationException("No Entry \"" + string + "\"");
        }
        entry.create(outputStream);
    }

    private void setCreateEntry(Element element, URL uRL, Parameters parameters) throws LoadingException, IOException {
        BasicEntry basicEntry;
        URL uRL2 = new URL(uRL, element.getAttribute("source"));
        String string = element.getAttribute("target");
        Entry entry = this.entries.put(string, basicEntry = new BasicEntry(this.engine, uRL2, string, element, parameters));
        if (entry != null && !entry.equals(basicEntry)) {
            throw new LoadingException("Duplicate Entry \"" + string + "\"");
        }
    }

    private void setResourceEntry(Element element, URL uRL) throws LoadingException, IOException {
        ResourceEntry resourceEntry;
        URL uRL2 = new URL(uRL, element.getAttribute("source"));
        String string = element.getAttribute("target");
        Entry entry = this.entries.put(string, resourceEntry = new ResourceEntry(this.engine, uRL2, string));
        if (entry != null && !entry.equals(resourceEntry)) {
            throw new LoadingException("Duplicate Entry \"" + string + "\"");
        }
    }

    private void processEntry(Element element, URL uRL, Parameters parameters) throws LoadingException, IOException {
        Object object;
        String string = element.getAttribute("producer");
        URL uRL2 = new URL(uRL, element.getAttribute("source"));
        BasicContext basicContext = new BasicContext(uRL2, "");
        basicContext.merge(parameters);
        this.engine.debug(this, "Processing Source=\"" + uRL2 + "\" [" + string + "]");
        Producer producer = this.engine.getProducer(string);
        if (producer == null) {
            throw new LoadingException("Invalid Producer \"" + string + "\"");
        }
        NodeList nodeList = element.getChildNodes();
        basicContext.merge(new NodeListParameters(nodeList));
        Document document = null;
        try {
            document = producer.produce(basicContext);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1 || (object = (Element)nodeList.item(i)).getTagName().equals("parameter")) continue;
                if (!object.getTagName().equals("processor")) {
                    throw new LoadingException("Invalid <" + object.getTagName() + ">");
                }
                Processor processor = this.engine.getProcessor(object.getAttribute("name"));
                if (processor == null) {
                    throw new LoadingException("No Processr \"" + processor + "\"");
                }
                Parameters parameters2 = new NodeListParameters(object.getChildNodes()).merge(basicContext);
                document = processor.process(document, basicContext, parameters2);
            }
        }
        catch (CreationException creationException) {
            creationException.printStackTrace(System.out);
            throw new LoadingException("Processing Entry (" + creationException.getMessage() + ")");
        }
        if (document == null) {
            return;
        }
        Element element2 = document.getDocumentElement();
        if (!element2.getTagName().equals("project")) {
            throw new LoadingException("Result of process is not <project>");
        }
        nodeList = element2.getChildNodes();
        object = new NodeListParameters(nodeList).merge(basicContext);
        this.processNodeList(nodeList, uRL2, (Parameters)object);
    }
}

