/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.Priority;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.CategoryFactory;

public class Hierarchy {
    static final int DISABLE_OFF = -1;
    static final int DISABLE_OVERRIDE = -2;
    private CategoryFactory defaultFactory;
    Hashtable ht = new Hashtable();
    Category root;
    RendererMap rendererMap;
    int disable;
    boolean emittedNoAppenderWarning = false;
    boolean emittedNoResourceBundleWarning = false;

    public Hierarchy(Category root) {
        this.root = root;
        this.disable = -1;
        this.root.setHierarchy(this);
        this.rendererMap = new RendererMap();
        this.defaultFactory = new DefaultCategoryFactory();
    }

    public void addRenderer(Class classToRender, ObjectRenderer or) {
        this.rendererMap.put(classToRender, or);
    }

    public void clear() {
        this.ht.clear();
    }

    public Category exists(String name) {
        Object o = this.ht.get(new CategoryKey(name));
        if (o instanceof Category) {
            return (Category)o;
        }
        return null;
    }

    public void disable(String priorityStr) {
        if (this.disable != -2) {
            Priority p = Priority.toPriority(priorityStr, null);
            if (p != null) {
                this.disable = p.level;
            } else {
                LogLog.warn("Could not convert [" + priorityStr + "] to Priority.");
            }
        }
    }

    public void disable(Priority p) {
        if (this.disable != -2 && p != null) {
            this.disable = p.level;
        }
    }

    public void disableAll() {
        this.disable(Priority.FATAL);
    }

    public void disableDebug() {
        this.disable(Priority.DEBUG);
    }

    public void disableInfo() {
        this.disable(Priority.INFO);
    }

    public void enableAll() {
        this.disable = -1;
    }

    public void overrideAsNeeded(String override) {
        if (override != null) {
            LogLog.debug("Handling non-null disable override directive: \"" + override + "\".");
            if (OptionConverter.toBoolean(override, true)) {
                LogLog.debug("Overriding all disable methods.");
                this.disable = -2;
            }
        }
    }

    public Category getInstance(String name) {
        return this.getInstance(name, this.defaultFactory);
    }

    public Category getInstance(String name, CategoryFactory factory) {
        CategoryKey key = new CategoryKey(name);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object o = this.ht.get(key);
            if (o == null) {
                Category category = factory.makeNewCategoryInstance(name);
                category.setHierarchy(this);
                this.ht.put(key, category);
                this.updateParents(category);
                Category category2 = category;
                return category2;
            }
            if (o instanceof Category) {
                Category category = (Category)o;
                return category;
            }
            if (o instanceof ProvisionNode) {
                Category category = factory.makeNewCategoryInstance(name);
                category.setHierarchy(this);
                this.ht.put(key, category);
                this.updateChildren((ProvisionNode)o, category);
                this.updateParents(category);
                Category category3 = category;
                return category3;
            }
            Category category = null;
            return category;
        }
    }

    public Enumeration getCurrentCategories() {
        Vector v = new Vector(this.ht.size());
        Enumeration elems = this.ht.elements();
        while (elems.hasMoreElements()) {
            Object o = elems.nextElement();
            if (!(o instanceof Category)) continue;
            v.addElement(o);
        }
        return v.elements();
    }

    public boolean isDisabled(int level) {
        return this.disable >= level;
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Category getRoot() {
        return this.root;
    }

    public void resetConfiguration() {
        this.getRoot().setPriority(Priority.DEBUG);
        this.root.setResourceBundle(null);
        this.disable = -1;
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            this.shutdown();
            Enumeration cats = this.getCurrentCategories();
            while (cats.hasMoreElements()) {
                Category c = (Category)cats.nextElement();
                c.setPriority(null);
                c.setAdditivity(true);
                c.setResourceBundle(null);
            }
        }
        this.rendererMap.clear();
    }

    public void setCategoryFactory(CategoryFactory factory) {
        if (factory != null) {
            this.defaultFactory = factory;
        }
    }

    public void setDisableOverride(String override) {
        if (OptionConverter.toBoolean(override, true)) {
            LogLog.debug("Overriding disable.");
            this.disable = -2;
        }
    }

    public void shutdown() {
        Category root = this.getRoot();
        root.closeNestedAppenders();
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Category c;
            Enumeration cats = this.getCurrentCategories();
            while (cats.hasMoreElements()) {
                c = (Category)cats.nextElement();
                c.closeNestedAppenders();
            }
            root.removeAllAppenders();
            cats = this.getCurrentCategories();
            while (cats.hasMoreElements()) {
                c = (Category)cats.nextElement();
                c.removeAllAppenders();
            }
        }
    }

    private final void updateParents(Category cat) {
        String name = cat.name;
        int length = name.length();
        boolean parentFound = false;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            String substr = name.substring(0, i);
            CategoryKey key = new CategoryKey(substr);
            Object o = this.ht.get(key);
            if (o == null) {
                ProvisionNode pn = new ProvisionNode(cat);
                this.ht.put(key, pn);
            } else {
                if (o instanceof Category) {
                    parentFound = true;
                    cat.parent = (Category)o;
                    break;
                }
                if (o instanceof ProvisionNode) {
                    ((ProvisionNode)o).addElement(cat);
                } else {
                    IllegalStateException e = new IllegalStateException("unexpected object type " + o.getClass() + " in ht.");
                    e.printStackTrace();
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (!parentFound) {
            cat.parent = this.root;
        }
    }

    private final void updateChildren(ProvisionNode pn, Category cat) {
        int last = pn.size();
        int i = 0;
        while (i < last) {
            Category c = (Category)pn.elementAt(i);
            if (!c.parent.name.startsWith(cat.name)) {
                cat.parent = c.parent;
                c.parent = cat;
            }
            ++i;
        }
    }
}

