/* Value Objects BEGIN */

<XDtComment:comment>
This part adds methods to handle 1-n relationships to add/remove/update one
entry of a specific relationship.  Difference is made between aggregation and
composition
</XDtComment:comment>

  <XDtEjbValueObj:forAllRelations superclasses="true" valueobject="<XDtEjbValueObj:valueObjectMatch/>">
   <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="type">
   public void add<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(<XDtEjbValueObj:currentAggregateType/> added)
   throws javax.ejb.CreateException
   {
      try{
        <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>">
         <XDtEjbPk:pkClass/> pk = new <XDtEjbPk:pkClass/>(<XDtEjbPk:pkfieldListFrom name="added"/>);
        </XDtClass:pushClass>
        <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="compose">
         <XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members"/> relation = <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/></XDtClass:pushClass>.getHome().create(added);
        </XDtMethod:ifHasMethodTag>
        <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="aggregate">
         <XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members"/> relation = <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/>.getHome().findByPrimaryKey(pk)</XDtClass:pushClass>;
         </XDtMethod:ifHasMethodTag>
         <XDtMethod:methodName/>().add(relation);
      }
      catch (Exception e){
         if (e instanceof javax.ejb.CreateException)
            throw (javax.ejb.CreateException)e;
         else
            throw new javax.ejb.EJBException(e);
      }
   }

   public void remove<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(<XDtEjbValueObj:currentAggregateType/> removed)
   throws javax.ejb.RemoveException
   {
      try{
        <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>">
        <XDtEjbPk:pkClass/> pk = new <XDtEjbPk:pkClass/>(<XDtEjbPk:pkfieldListFrom name="removed"/>);
        </XDtClass:pushClass>
        <XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members"/> relation = <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/>.getHome().findByPrimaryKey(pk)</XDtClass:pushClass>;
        <XDtMethod:methodName/>().remove(relation);
        <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="compose">
        relation.remove();
        </XDtMethod:ifHasMethodTag>
      }
      catch (Exception e){
         if (e instanceof javax.ejb.RemoveException)
            throw (javax.ejb.RemoveException)e;
         else
            throw new javax.ejb.EJBException(e);
      }
   }

   <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="compose">
   public void update<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(<XDtEjbValueObj:currentAggregateType/> updated)
   {
      try{
        <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>">
        <XDtEjbPk:pkClass/> pk = new <XDtEjbPk:pkClass/>(<XDtEjbPk:pkfieldListFrom name="updated"/>);
        </XDtClass:pushClass>
        <XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members"/> relation = <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/>.getHome().findByPrimaryKey(pk)</XDtClass:pushClass>;
        relation.set<XDtEjbValueObj:currentAggregateType short="true"/>(updated);
      }
      catch (Exception e){
         throw new javax.ejb.EJBException(e);
      }
   }

   </XDtMethod:ifHasMethodTag>
   </XDtMethod:ifHasMethodTag>
  </XDtEjbValueObj:forAllRelations>

  <XDtEjbValueObj:forAllValueObjects>
   private <XDtEjbValueObj:currentValueObjectClass/> <XDtEjbValueObj:currentValueObjectAttribute/>;

   public <XDtEjbValueObj:valueMostSuperObjectClass/> get<XDtEjbValueObj:currentValueObjectAttribute/>()
   {
      if( <XDtEjbValueObj:currentValueObjectAttribute/> == null )
      {
        <XDtMerge:merge file="xdoclet/ejb/entity-value-instantiation.j">
        </XDtMerge:merge>
      }

     <XDtEjbPersistent:forAllPersistentFields valueobject="<XDtEjbValueObj:currentValueObjectMatch/>">
     <XDtMethod:ifHasMethod name="<XDtMethod:setterMethod/>" parameters="<XDtMethod:methodType/>">
     <XDtMethod:ifMethodTagValueEquals tagName="ejb:value-object" paramName="relation" value="external">
      <XDtEjbValueObj:currentValueObjectAttribute/>.<XDtMethod:setterMethod/>( <XDtMethod:getterMethod/>() );
     </XDtMethod:ifMethodTagValueEquals>
     </XDtMethod:ifHasMethod>
     </XDtEjbPersistent:forAllPersistentFields>

      return <XDtEjbValueObj:currentValueObjectAttribute/>;
   }
  </XDtEjbValueObj:forAllValueObjects>

 <XDtEjbValueObj:forAllSuperSetValue>
   public void set<XDtEjbValueObj:currentValueObjectAttribute/>( <XDtEjbValueObj:currentValueObjectClass/> valueHolder )
   {
     <XDtEjbBmp:ifUseSoftLocking>
      if( getVersion() != valueHolder.getVersion() )
         throw new IllegalStateException( "Wrong version. Had " + getVersion() + ", got " + valueHolder.getVersion() );
     </XDtEjbBmp:ifUseSoftLocking>

      try
      {
      <XDtEjbPersistent:forAllPersistentFields not-pk="true" valueobject="<XDtEjbValueObj:currentValueObjectMatch/>">
        <XDtMethod:ifHasMethod name="<XDtMethod:setterMethod/>" parameters="<XDtMethod:methodType/>">
         <XDtMethod:setterMethod/>( valueHolder.<XDtMethod:getterMethod/>() );
         this.<XDtEjbValueObj:currentValueObjectAttribute/>.<XDtMethod:setterMethod/>( valueHolder.<XDtMethod:getterMethod/>() );
        </XDtMethod:ifHasMethod>
      </XDtEjbPersistent:forAllPersistentFields>
      <XDtEjbValueObj:forAllAggregates superclasses="true" valueobject="<XDtEjbValueObj:valueObjectMatch/>">
       <XDtMethod:ifDoesntHaveMethodTag tagName="ejb:value-object" paramName="type">
        <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>">
         <XDtEjbPk:pkClass/> pk = new <XDtEjbPk:pkClass/>(<XDtEjbPk:pkfieldListFrom name="valueHolder.get<XDtEjbValueObj:currentAggregateName/>()"/>);
        </XDtClass:pushClass>
         <XDtMethod:methodType/> relation = <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/>.getHome().findByPrimaryKey(pk)</XDtClass:pushClass>;
         <XDtMethod:setterMethod/>(relation);
         this.<XDtEjbValueObj:currentValueObjectAttribute/>.set<XDtEjbValueObj:currentAggregateName/>( valueHolder.get<XDtEjbValueObj:currentAggregateName/>() );
        </XDtMethod:ifDoesntHaveMethodTag>
        <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="type">
         this.<XDtEjbValueObj:currentValueObjectAttribute/>.copy<XDtEjbValueObj:currentAggregateName/>sFrom(valueHolder);
<XDtComment:comment>
Here we take what has changed (update/add/remove) inside the VO collection and
call methods according to.  These methods are extracted so that you can define
them abstract with a ejb:interface tag to give them access from the outside.
</XDtComment:comment>
         java.util.Iterator i<XDtEjbValueObj:currentAggregateName/> = valueHolder.getAdded<XDtEjbValueObj:currentAggregateName/>s().iterator();
         while (i<XDtEjbValueObj:currentAggregateName/>.hasNext())
         {
            <XDtEjbValueObj:currentAggregateType/> o = (<XDtEjbValueObj:currentAggregateType/>)i<XDtEjbValueObj:currentAggregateName/>.next();
            add<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(o);
         }
         i<XDtEjbValueObj:currentAggregateName/> = valueHolder.getRemoved<XDtEjbValueObj:currentAggregateName/>s().iterator();
         while (i<XDtEjbValueObj:currentAggregateName/>.hasNext())
         {
            <XDtEjbValueObj:currentAggregateType/> o = (<XDtEjbValueObj:currentAggregateType/>)i<XDtEjbValueObj:currentAggregateName/>.next();
            remove<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(o);
         }
        </XDtMethod:ifHasMethodTag>
      </XDtEjbValueObj:forAllAggregates>
      <XDtEjbValueObj:forAllComposes superclasses="false" valueobject="<XDtEjbValueObj:valueObjectMatch/>">
       <XDtMethod:ifDoesntHaveMethodTag tagName="ejb:value-object" paramName="type">
        <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>">
         <XDtEjbPk:pkClass/> pk = new <XDtEjbPk:pkClass/>(<XDtEjbPk:pkfieldListFrom name="valueHolder.get<XDtEjbValueObj:currentAggregateName/>()"/>);
        </XDtClass:pushClass>
         <XDtMethod:methodType/> relation = <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/>.getHome().findByPrimaryKey(pk)</XDtClass:pushClass>;
         relation.set<XDtEjbValueObj:currentAggregateName/>(valueHolder.get<XDtEjbValueObj:currentAggregateName/>());
         this.<XDtEjbValueObj:currentValueObjectAttribute/>.set<XDtEjbValueObj:currentAggregateName/>( <XDtClass:pushClass value="<XDtEjbValueObj:currentRelationBeanClass/>"><XDtEjbUtilObj:utilClass/>.getHome().findByPrimaryKey(pk)</XDtClass:pushClass>.get<XDtEjbValueObj:currentAggregateName/>() );
        </XDtMethod:ifDoesntHaveMethodTag>
        <XDtMethod:ifHasMethodTag tagName="ejb:value-object" paramName="type">
         this.<XDtEjbValueObj:currentValueObjectAttribute/>.copy<XDtEjbValueObj:currentAggregateName/>sFrom(valueHolder);
<XDtComment:comment>
Here we take what has changed (update/add/remove) inside the VO collection and
call methods according to.  These methods are extracted so that you can define
them abstract with a ejb:interface tag to give them access from the outside.
</XDtComment:comment>
         java.util.Iterator i<XDtEjbValueObj:currentAggregateName/> = valueHolder.getUpdated<XDtEjbValueObj:currentAggregateName/>s().iterator();
         while (i<XDtEjbValueObj:currentAggregateName/>.hasNext())
         {
            <XDtEjbValueObj:currentAggregateType/> o = (<XDtEjbValueObj:currentAggregateType/>)i<XDtEjbValueObj:currentAggregateName/>.next();
            update<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(o);
         }
         i<XDtEjbValueObj:currentAggregateName/> = valueHolder.getAdded<XDtEjbValueObj:currentAggregateName/>s().iterator();
         while (i<XDtEjbValueObj:currentAggregateName/>.hasNext())
         {
            <XDtEjbValueObj:currentAggregateType/> o = (<XDtEjbValueObj:currentAggregateType/>)i<XDtEjbValueObj:currentAggregateName/>.next();
            add<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(o);
         }
         i<XDtEjbValueObj:currentAggregateName/> = valueHolder.getRemoved<XDtEjbValueObj:currentAggregateName/>s().iterator();
         while (i<XDtEjbValueObj:currentAggregateName/>.hasNext())
         {
            <XDtEjbValueObj:currentAggregateType/> o = (<XDtEjbValueObj:currentAggregateType/>)i<XDtEjbValueObj:currentAggregateName/>.next();
            remove<XDtMethod:methodTagValue tagName="ejb:value-object" paramName="members-name"/>(o);
         }
        </XDtMethod:ifHasMethodTag>
      </XDtEjbValueObj:forAllComposes>
      }
      catch (Exception e)
      {
         throw new javax.ejb.EJBException(e);
      }
   }
 </XDtEjbValueObj:forAllSuperSetValue>


/* Value Objects END */