/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.ejb.tags.DataObjectTagsHandler;
import xdoclet.tags.PackageTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public class DataObjectSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String SUBTASK_NAME = "dataobject";
    public static final String DEFAULT_DATAOBJECT_CLASS_PATTERN = "{0}Data";
    protected static String DEFAULT_TEMPLATE_FILE = "/xdoclet/ejb/dataobject.j";
    protected String dataObjectClassPattern;
    static /* synthetic */ Class class$xdoclet$ejb$DataObjectSubTask;

    public DataObjectSubTask() {
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getDataObjectClassPattern() + ".java");
        this.setOfType("javax.ejb.EntityBean");
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public String getDataObjectClassPattern() {
        if (this.dataObjectClassPattern != null) {
            return this.dataObjectClassPattern;
        }
        return DEFAULT_DATAOBJECT_CLASS_PATTERN;
    }

    public void setPattern(String new_pattern) {
        this.dataObjectClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getDataObjectClassPattern() == null || this.getDataObjectClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString("parameter_missing_or_empty", new String[]{"pattern"}));
        }
        if (this.getDataObjectClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString("xdoclet.ejb.Messages", "pattern_has_no_placeholder"));
        }
    }

    protected String getGeneratedFileName(ClassDoc clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(DataObjectTagsHandler.getDataObjectClassFor(this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(ClassDoc clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        Category cat = Log.getCategory(class$xdoclet$ejb$DataObjectSubTask == null ? (class$xdoclet$ejb$DataObjectSubTask = DataObjectSubTask.class$("xdoclet.ejb.DataObjectSubTask")) : class$xdoclet$ejb$DataObjectSubTask, "matchesGenerationRules");
        return DataObjectTagsHandler.isGenerationNeeded(this.getCurrentClass());
    }

    protected void generateForClass(ClassDoc clazz) throws XDocletException {
        if (DataObjectTagsHandler.hasCustomBulkData(this.getCurrentClass())) {
            Tag[] bdo = DocletUtil.getTagsByName(this.getCurrentClass(), "ejb:bulk-data");
            StringTokenizer stringTokenizer = new StringTokenizer(bdo[0].text(), " ");
            DataObjectTagsHandler.setCurrentDataObjectClassname(stringTokenizer.nextToken().trim());
            DataObjectTagsHandler.putDataObjectClassnames(this.getCurrentClass().name(), DataObjectTagsHandler.getCurrentDataObjectClassname());
        } else {
            DataObjectTagsHandler.setCurrentDataObjectClassname(DataObjectTagsHandler.generateDataObjectClass(clazz));
            DataObjectTagsHandler.putDataObjectClassnames(this.getCurrentClass().name(), DataObjectTagsHandler.getCurrentDataObjectClassname());
        }
        super.generateForClass(clazz);
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString("xdoclet.ejb.Messages", "generating_dataobject_for", new String[]{this.getCurrentClass().qualifiedName()}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

