/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.text.MessageFormat;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.ejb.SessionSubTask;
import xdoclet.ejb.tags.EjbTagsHandler;
import xdoclet.tags.TypeTagsHandler;
import xdoclet.util.DocletUtil;

public class SessionTagsHandler
extends EjbTagsHandler {
    public static String getSessionClassFor(ClassDoc clazz) throws XDocletException {
        String fileName = clazz.containingPackage().name();
        String session_name = MessageFormat.format(SessionTagsHandler.getSessionClassPattern(), EjbTagsHandler.getShortEjbNameFor(clazz));
        if ((fileName = EjbTagsHandler.choosePackage(fileName, null, "session")).length() > 0) {
            fileName = fileName + ".";
        }
        fileName = fileName + session_name;
        return fileName;
    }

    public static boolean isSession(ClassDoc clazz) throws XDocletException {
        return TypeTagsHandler.isOfType((Type)clazz, "javax.ejb.SessionBean", 2);
    }

    protected static String getSessionClassPattern() {
        SessionSubTask session_subtask = (SessionSubTask)DocletContext.getInstance().getSubTaskBy("session");
        if (session_subtask != null) {
            return session_subtask.getSessionClassPattern();
        }
        return SessionSubTask.DEFAULT_SESSION_CLASS_PATTERN;
    }

    public boolean isStatefulSession(ClassDoc clazz) throws XDocletException {
        if (!SessionTagsHandler.isSession(clazz)) {
            return false;
        }
        String value = this.getParameterValue(DocletUtil.getText((Doc)this.getCurrentClass(), "ejb:bean"), "type", -1);
        return value != null && value.equals("Stateful");
    }

    public boolean isStatelessSession(ClassDoc clazz) throws XDocletException {
        if (!SessionTagsHandler.isSession(clazz)) {
            return false;
        }
        String value = null;
        String bean_str = DocletUtil.getText((Doc)this.getCurrentClass(), "ejb:bean");
        if (bean_str != null) {
            value = this.getParameterValue(bean_str, "type", -1);
        }
        if (value != null) {
            return value.equals("Stateless");
        }
        if (TypeTagsHandler.isOfType((Type)clazz, "javax.ejb.SessionSynchronization", 2)) {
            return false;
        }
        MethodDoc[] methods = clazz.methods();
        boolean has_empty_create_method = false;
        boolean has_other_create_methods = false;
        int i = 0;
        while (i < methods.length) {
            MethodDoc method = methods[i];
            if (method.name().equals("ejbCreate") && method.parameters().length == 0) {
                has_empty_create_method = true;
            } else if (method.name().startsWith("ejbCreate") && method.parameters().length > 0 && method.returnType().typeName().equals("void")) {
                has_other_create_methods = true;
            }
            ++i;
        }
        return has_empty_create_method && !has_other_create_methods;
    }

    public String sessionClass() throws XDocletException {
        return SessionTagsHandler.getSessionClassFor(this.getCurrentClass());
    }

    public void ifStatelessSession(String template) throws XDocletException {
        if (this.isStatelessSession(this.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifNotStatelessSession(String template) throws XDocletException {
        if (!this.isStatelessSession(this.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifStatefulSession(String template) throws XDocletException {
        if (this.isStatefulSession(this.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void forAllSessionBeans(String template) throws XDocletException {
        ClassDoc[] classes = XDocletTagSupport.getDocletContext().getRoot().classes();
        int i = 0;
        while (i < classes.length) {
            this.setCurrentClass(classes[i]);
            if (!DocletSupport.isDocletGenerated(this.getCurrentClass()) && SessionTagsHandler.isSession(this.getCurrentClass())) {
                this.generate(template);
            }
            ++i;
        }
    }

    public void forAllStatefulSessionBeans(String template) throws XDocletException {
        ClassDoc[] classes = XDocletTagSupport.getDocletContext().getRoot().classes();
        int i = 0;
        while (i < classes.length) {
            this.setCurrentClass(classes[i]);
            if (!DocletSupport.isDocletGenerated(this.getCurrentClass()) && this.isStatefulSession(this.getCurrentClass())) {
                this.generate(template);
            }
            ++i;
        }
    }

    public void forAllStatelessSessionBeans(String template) throws XDocletException {
        ClassDoc[] classes = XDocletTagSupport.getDocletContext().getRoot().classes();
        int i = 0;
        while (i < classes.length) {
            this.setCurrentClass(classes[i]);
            if (!DocletSupport.isDocletGenerated(this.getCurrentClass()) && this.isStatelessSession(this.getCurrentClass())) {
                this.generate(template);
            }
            ++i;
        }
    }
}

