/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.apache.ant;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.modules.apache.ant.TaskTagsHandler;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.XClass;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;

public class TaskSubTask
extends TemplateSubTask {
    public static final boolean isAntTask(XClass clazz) throws XDocletException {
        if (clazz.isAbstract()) {
            return false;
        }
        if (clazz.isInner()) {
            return false;
        }
        String ignoreValue = clazz.getDoc().getTagAttributeValue("ant.task", "ignore");
        boolean ignore = TypeConversionUtil.stringToBoolean((String)ignoreValue, (boolean)false);
        if (ignore) {
            return false;
        }
        return TaskSubTask.hasExecuteMethod(clazz);
    }

    private static boolean hasExecuteMethod(XClass clazz) {
        if (clazz == null) {
            return false;
        }
        if ("org.apache.tools.ant.Task".equals(clazz.getQualifiedName()) || "org.apache.tools.ant.Target".equals(clazz.getQualifiedName()) || "org.apache.tools.ant.TaskAdapter".equals(clazz.getQualifiedName()) || "org.apache.tools.ant.UnknownElement".equals(clazz.getQualifiedName())) {
            return false;
        }
        Collection methods = clazz.getMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            XMethod method = (XMethod)iter.next();
            if (!"execute".equals(method.getName()) || method.getParameters().size() != 0 || !method.getReturnType().getName().equals("void")) continue;
            return true;
        }
        return TaskSubTask.hasExecuteMethod(clazz.getSuperclass());
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        String dir = TaskTagsHandler.getCategoryName(clazz);
        String taskName = TaskTagsHandler.getTaskName(clazz);
        return new File(dir, taskName + ".xml").toString();
    }

    protected void startProcessForAll() throws XDocletException {
        super.startProcessForAll();
    }

    protected void startProcess() throws XDocletException {
        Collection classes = XJavaDoc.getInstance().getSourceClasses(false, this.processInnerClasses());
        super.startProcess();
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        boolean match = TaskSubTask.isAntTask(clazz);
        return match;
    }
}

