/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXConfigurationHandler
extends DefaultHandler
implements ErrorHandler {
    private final ArrayList m_elements = new ArrayList();
    private Configuration m_configuration;
    private Locator m_locator;

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void clear() {
        this.m_elements.clear();
        this.m_locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        String value = new String(ch, start, end).trim();
        if (value.equals("")) {
            return;
        }
        DefaultConfiguration configuration = (DefaultConfiguration)this.m_elements.get(this.m_elements.size() - 1);
        if (configuration.getChildCount() != 0) {
            throw new SAXException("Not allowed to define mixed content in the element " + configuration.getName() + " at " + configuration.getLocation());
        }
        value = configuration.getValue("") + value;
        configuration.setValue(value);
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        int location = this.m_elements.size() - 1;
        Object object = this.m_elements.remove(location);
        if (location == 0) {
            this.m_configuration = (Configuration)object;
        }
    }

    protected DefaultConfiguration createConfiguration(String localName, String location) {
        return new DefaultConfiguration(localName, location);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        DefaultConfiguration configuration = this.createConfiguration(rawName, this.getLocationString());
        int size = this.m_elements.size() - 1;
        if (size > -1) {
            DefaultConfiguration parent = (DefaultConfiguration)this.m_elements.get(size);
            if (parent.getValue(null) != null) {
                throw new SAXException("Not allowed to define mixed content in the element " + parent.getName() + " at " + parent.getLocation());
            }
            parent.addChild(configuration);
        }
        this.m_elements.add(configuration);
        int attributesSize = attributes.getLength();
        int i = 0;
        while (i < attributesSize) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            configuration.setAttribute(name, value);
            ++i;
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    protected String getLocationString() {
        if (this.m_locator == null) {
            return "Unknown";
        }
        return this.m_locator.getSystemId() + ":" + this.m_locator.getLineNumber() + ":" + this.m_locator.getColumnNumber();
    }
}

