/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class SAXParser {
    protected SAXParser() {
    }

    public abstract Parser getParser() throws SAXException;

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public void parse(File file, HandlerBase handlerBase) throws SAXException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String string = "file:" + file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource, handlerBase);
    }

    public void parse(InputStream inputStream, HandlerBase handlerBase) throws SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        InputSource inputSource = new InputSource(inputStream);
        this.parse(inputSource, handlerBase);
    }

    public void parse(String string, HandlerBase handlerBase) throws SAXException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource, handlerBase);
    }

    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        Parser parser = this.getParser();
        if (handlerBase != null) {
            parser.setDocumentHandler(handlerBase);
            parser.setEntityResolver(handlerBase);
            parser.setErrorHandler(handlerBase);
            parser.setDTDHandler(handlerBase);
        }
        parser.parse(inputSource);
    }
}

