/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util.serialveruid;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;

public class SerialVersionUidGenerator {
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();

    public static long computeSerialVersionUID(ClassDoc cl) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            int i;
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            data.writeUTF(cl.name());
            int classaccess = cl.modifierSpecifier();
            MethodDoc[] method = cl.methods();
            if (((classaccess &= 0x611) & 0x200) != 0) {
                classaccess &= 0xFFFFFBFF;
                if (method.length > 0) {
                    classaccess |= 0x400;
                }
            }
            data.writeInt(classaccess);
            if (!cl.dimension().equals("")) {
                ClassDoc[] interfaces = cl.interfaces();
                Arrays.sort(interfaces, compareClassByName);
                i = 0;
                while (i < interfaces.length) {
                    data.writeUTF("L" + interfaces[i].qualifiedName());
                    ++i;
                }
            }
            FieldDoc[] field = cl.fields();
            Arrays.sort(field, compareMemberByName);
            i = 0;
            while (i < field.length) {
                FieldDoc f = field[i];
                int m = f.modifierSpecifier();
                if (!Modifier.isPrivate(m) || !Modifier.isTransient(m) && !Modifier.isStatic(m)) {
                    data.writeUTF(f.name());
                    data.writeInt(m);
                    data.writeUTF(SerialVersionUidGenerator.getSignature(f.type().qualifiedTypeName(), f.type().asClassDoc(), f.type().dimension()));
                }
                ++i;
            }
            MethodSignature[] constructors = MethodSignature.removePrivateAndSort((MemberDoc[])cl.constructors());
            int i2 = 0;
            while (i2 < constructors.length) {
                MethodSignature c = constructors[i2];
                String mname = "<init>";
                String desc = c.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(mname);
                data.writeInt(c.member.modifierSpecifier());
                data.writeUTF(desc);
                ++i2;
            }
            MethodSignature[] methods = MethodSignature.removePrivateAndSort((MemberDoc[])method);
            int i3 = 0;
            while (i3 < methods.length) {
                MethodSignature m = methods[i3];
                String desc = m.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(m.member.qualifiedName());
                data.writeInt(m.member.modifierSpecifier());
                data.writeUTF(desc);
                ++i3;
            }
            data.flush();
            byte[] hasharray = md.digest();
            int i4 = 0;
            while (i4 < Math.min(8, hasharray.length)) {
                h += (long)(hasharray[i4] & 0xFF) << i4 * 8;
                ++i4;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return h;
    }

    static String getSignature(String type_name, ClassDoc clazz, String dimension) {
        String type = null;
        boolean is_array = dimension.equals("");
        if (is_array) {
            ClassDoc cl = clazz;
            int dimensions = 0;
            StringTokenizer dimensions_st = new StringTokenizer(dimension, "[", true);
            while (dimensions_st.hasMoreTokens()) {
                dimensions_st.nextToken();
                ++dimensions;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < dimensions) {
                sb.append("[");
                ++i;
            }
            sb.append(type_name);
            type = sb.toString();
        } else {
            type = clazz == null ? (type_name.equals("int") ? "I" : (type_name.equals("byte") ? "B" : (type_name.equals("long") ? "J" : (type_name.equals("float") ? "F" : (type_name.equals("double") ? "D" : (type_name.equals("short") ? "S" : (type_name.equals("char") ? "C" : (type_name.equals("boolean") ? "Z" : (type_name.equals("void") ? "V" : "V"))))))))) : "L" + clazz.qualifiedName().replace('.', '/') + ";";
        }
        return type;
    }

    static String getSignature(MethodDoc meth) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Parameter[] params = meth.parameters();
        int j = 0;
        while (j < params.length) {
            Parameter param = params[j];
            sb.append(SerialVersionUidGenerator.getSignature(param.type().qualifiedTypeName(), param.type().asClassDoc(), param.type().dimension()));
            ++j;
        }
        sb.append(")");
        Type ret = meth.returnType();
        sb.append(SerialVersionUidGenerator.getSignature(ret.qualifiedTypeName(), ret.asClassDoc(), ret.dimension()));
        return sb.toString();
    }

    static String getSignature(ConstructorDoc cons) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Parameter[] params = cons.parameters();
        int j = 0;
        while (j < params.length) {
            Parameter param = params[j];
            sb.append(SerialVersionUidGenerator.getSignature(param.type().qualifiedTypeName(), param.type().asClassDoc(), param.type().dimension()));
            ++j;
        }
        sb.append(")V");
        return sb.toString();
    }

    private static class MethodSignature
    implements Comparator {
        MemberDoc member;
        String signature;

        private MethodSignature(MemberDoc m) {
            this.member = m;
            this.signature = this.isConstructor() ? SerialVersionUidGenerator.getSignature((ConstructorDoc)m) : SerialVersionUidGenerator.getSignature((MethodDoc)m);
        }

        public int compare(Object o1, Object o2) {
            int result;
            if (o1 == o2) {
                return 0;
            }
            MethodSignature c1 = (MethodSignature)o1;
            MethodSignature c2 = (MethodSignature)o2;
            if (this.isConstructor()) {
                result = c1.signature.compareTo(c2.signature);
            } else {
                result = c1.member.qualifiedName().compareTo(c2.member.qualifiedName());
                if (result == 0) {
                    result = c1.signature.compareTo(c2.signature);
                }
            }
            return result;
        }

        private boolean isConstructor() {
            return this.member instanceof ConstructorDoc;
        }

        static MethodSignature[] removePrivateAndSort(MemberDoc[] m) {
            int numNonPrivate = 0;
            int i = 0;
            while (i < m.length) {
                if (!Modifier.isPrivate(m[i].modifierSpecifier())) {
                    ++numNonPrivate;
                }
                ++i;
            }
            MethodSignature[] cm = new MethodSignature[numNonPrivate];
            int cmi = 0;
            int i2 = 0;
            while (i2 < m.length) {
                if (!Modifier.isPrivate(m[i2].modifierSpecifier())) {
                    cm[cmi] = new MethodSignature(m[i2]);
                    ++cmi;
                }
                ++i2;
            }
            if (cmi > 0) {
                Arrays.sort(cm, cm[0]);
            }
            return cm;
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((MemberDoc)o1).qualifiedName();
            String s2 = ((MemberDoc)o2).qualifiedName();
            if (o1 instanceof MethodDoc) {
                s1 = s1 + SerialVersionUidGenerator.getSignature((MethodDoc)o1);
                s2 = s2 + SerialVersionUidGenerator.getSignature((MethodDoc)o2);
            } else if (o1 instanceof ConstructorDoc) {
                s1 = s1 + SerialVersionUidGenerator.getSignature((ConstructorDoc)o1);
                s2 = s2 + SerialVersionUidGenerator.getSignature((ConstructorDoc)o2);
            }
            return s1.compareTo(s2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }
}

