/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.jmx.vendor;

import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.util.Translator;

public class OpenJMXDescriptionAdapterSubTask
extends TemplateSubTask {
    public static final String SUBTASK_NAME = "openjmxDescription";
    protected static String mbeanDescriptionClassPattern;
    private static String DEFAULT_TEMPLATE_FILE;
    private static String GENERATED_FILE_NAME;

    public OpenJMXDescriptionAdapterSubTask() {
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_FILE_NAME);
        this.setHavingClassTag("jmx:mbean");
        mbeanDescriptionClassPattern = "{0}MBeanDescription";
    }

    public static String getMbeanDescriptionClassPattern() {
        return mbeanDescriptionClassPattern;
    }

    public String getSubTaskName() {
        return SUBTASK_NAME;
    }

    public void setPattern(String new_pattern) {
        mbeanDescriptionClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (OpenJMXDescriptionAdapterSubTask.getMbeanDescriptionClassPattern() == null || OpenJMXDescriptionAdapterSubTask.getMbeanDescriptionClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString("parameter_missing_or_empty", new String[]{"pattern"}));
        }
        if (OpenJMXDescriptionAdapterSubTask.getMbeanDescriptionClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString("xdoclet.jmx.Messages", "pattern_has_no_placeholder"));
        }
    }

    static {
        DEFAULT_TEMPLATE_FILE = "/xdoclet/jmx/vendor/openjmx-mbean-description.j";
        GENERATED_FILE_NAME = "{0}MBeanDescription.java";
    }
}

