/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    protected ArrayList list = null;
    protected boolean fast = false;

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public boolean add(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.add(object);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.add(object);
        }
    }

    public void add(int n, Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.add(n, object);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(n, object);
        }
    }

    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(collection);
        }
    }

    public boolean addAll(int n, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(n, collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(n, collection);
        }
    }

    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.clear();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    public Object clone() {
        FastArrayList fastArrayList = null;
        if (this.fast) {
            fastArrayList = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                fastArrayList = new FastArrayList((Collection)this.list);
            }
        }
        fastArrayList.setFast(this.getFast());
        return fastArrayList;
    }

    public boolean contains(Object object) {
        if (this.fast) {
            return this.list.contains(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.contains(object);
        }
    }

    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.containsAll(collection);
        }
    }

    public void ensureCapacity(int n) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.ensureCapacity(n);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(n);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.fast) {
            ListIterator listIterator = ((AbstractList)this.list).listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                Object e = listIterator.next();
                Object e2 = listIterator2.next();
                if (e == null ? e2 == null : e.equals(e2)) continue;
                return false;
            }
            return !(listIterator.hasNext() || listIterator2.hasNext());
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = ((AbstractList)this.list).listIterator();
            ListIterator listIterator3 = list.listIterator();
            while (listIterator.hasNext() && listIterator3.hasNext()) {
                Object e = listIterator.next();
                Object e3 = listIterator3.next();
                if (e == null ? e3 == null : e.equals(e3)) continue;
                return false;
            }
            return !(listIterator.hasNext() || listIterator3.hasNext());
        }
    }

    public Object get(int n) {
        if (this.fast) {
            return this.list.get(n);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(n);
        }
    }

    public int hashCode() {
        if (this.fast) {
            int n = 1;
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            return n;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = 1;
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            return n;
        }
    }

    public int indexOf(Object object) {
        if (this.fast) {
            return this.list.indexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.indexOf(object);
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.isEmpty();
        }
    }

    public Iterator iterator() {
        if (this.fast) {
            return ((AbstractList)this.list).iterator();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractList)this.list).iterator();
        }
    }

    public int lastIndexOf(Object object) {
        if (this.fast) {
            return this.list.lastIndexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.lastIndexOf(object);
        }
    }

    public ListIterator listIterator() {
        if (this.fast) {
            return ((AbstractList)this.list).listIterator();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractList)this.list).listIterator();
        }
    }

    public ListIterator listIterator(int n) {
        if (this.fast) {
            return ((AbstractList)this.list).listIterator(n);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractList)this.list).listIterator(n);
        }
    }

    public Object remove(int n) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                Object e = arrayList.remove(n);
                this.list = arrayList;
                return e;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(n);
        }
    }

    public boolean remove(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = ((AbstractCollection)arrayList).remove(object);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractCollection)this.list).remove(object);
        }
    }

    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = ((AbstractCollection)arrayList).removeAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractCollection)this.list).removeAll(collection);
        }
    }

    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = ((AbstractCollection)arrayList).retainAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractCollection)this.list).retainAll(collection);
        }
    }

    public Object set(int n, Object object) {
        if (this.fast) {
            return this.list.set(n, object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.set(n, object);
        }
    }

    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.size();
        }
    }

    public List subList(int n, int n2) {
        if (this.fast) {
            return ((AbstractList)this.list).subList(n, n2);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return ((AbstractList)this.list).subList(n, n2);
        }
    }

    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray();
        }
    }

    public Object[] toArray(Object[] objectArray) {
        if (this.fast) {
            return this.list.toArray(objectArray);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray(objectArray);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FastArrayList[");
        stringBuffer.append(this.list.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.trimToSize();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int n) {
        this.list = new ArrayList(n);
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }
}

