/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Tstamp
extends Task {
    private Vector customFormats = new Vector();

    public void execute() throws BuildException {
        try {
            Date d = new Date();
            SimpleDateFormat dstamp = new SimpleDateFormat("yyyyMMdd");
            this.project.setProperty("DSTAMP", dstamp.format(d));
            SimpleDateFormat tstamp = new SimpleDateFormat("HHmm");
            this.project.setProperty("TSTAMP", tstamp.format(d));
            SimpleDateFormat today = new SimpleDateFormat("MMMM d yyyy", Locale.US);
            this.project.setProperty("TODAY", today.format(d));
            Enumeration i = this.customFormats.elements();
            while (i.hasMoreElements()) {
                CustomFormat cts = (CustomFormat)i.nextElement();
                cts.execute(this.project, d, this.location);
            }
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public CustomFormat createFormat() {
        Tstamp tstamp = this;
        if (tstamp == null) {
            throw null;
        }
        CustomFormat cts = tstamp.new CustomFormat();
        this.customFormats.addElement(cts);
        return cts;
    }

    public class CustomFormat {
        private String propertyName;
        private String pattern;
        private int offset = 0;
        private int field = 5;

        public void setProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setUnit(String unit) {
            if (unit.equalsIgnoreCase("millisecond")) {
                this.field = 14;
            } else if (unit.equalsIgnoreCase("second")) {
                this.field = 13;
            } else if (unit.equalsIgnoreCase("minute")) {
                this.field = 12;
            } else if (unit.equalsIgnoreCase("hour")) {
                this.field = 11;
            } else if (unit.equalsIgnoreCase("day")) {
                this.field = 5;
            } else if (unit.equalsIgnoreCase("week")) {
                this.field = 3;
            } else if (unit.equalsIgnoreCase("month")) {
                this.field = 2;
            } else if (unit.equalsIgnoreCase("year")) {
                this.field = 1;
            } else {
                throw new BuildException(unit + " is not a unit supported by the tstamp task");
            }
        }

        public void execute(Project project, Date date, Location location) {
            if (this.propertyName == null) {
                throw new BuildException("property attribute must be provided", location);
            }
            if (this.pattern == null) {
                throw new BuildException("pattern attribute must be provided", location);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
            if (this.offset != 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(this.field, this.offset);
                date = calendar.getTime();
            }
            project.setProperty(this.propertyName, sdf.format(date));
        }
    }
}

