/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.util.datasource.DataSourceComponent;
import org.apache.avalon.util.datasource.JdbcConnectionPool;

public class JdbcDataSource
extends AbstractLoggable
implements DataSourceComponent {
    protected JdbcConnectionPool m_pool;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_pool) {
            String string = configuration.getChild("dburl").getValue();
            Configuration configuration2 = configuration.getChild("user");
            Configuration configuration3 = configuration.getChild("password");
            String string2 = null;
            String string3 = null;
            if (!configuration2.getLocation().equals("-")) {
                string2 = configuration2.getValue();
            }
            if (!configuration3.getLocation().equals("-")) {
                string3 = configuration3.getValue();
            }
            Configuration configuration4 = configuration.getChild("pool-controller");
            int n = configuration4.getAttributeAsInt("min", 0);
            int n2 = configuration4.getAttributeAsInt("max", 3);
            this.m_pool = new JdbcConnectionPool(string, string2, string3, n, n2);
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            connection = (Connection)((Object)this.m_pool.get());
        }
        catch (Exception exception) {
            this.getLogger().error("Could not return Connection", exception);
            throw new SQLException(exception.getMessage());
        }
        return connection;
    }

    public void dispose() {
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

