/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

public class CircularBuffer {
    protected Object[] m_buffer;
    protected int m_bufferSize;
    protected int m_contentSize;
    protected int m_head;
    protected int m_tail;

    public CircularBuffer(int n) {
        this.m_buffer = new Object[n];
        this.m_bufferSize = n;
        this.m_contentSize = 0;
        this.m_head = 0;
        this.m_tail = 0;
    }

    public CircularBuffer() {
        this(32);
    }

    public boolean isEmpty() {
        return this.m_contentSize == 0;
    }

    public int getContentSize() {
        return this.m_contentSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public void append(Object object) {
        if (this.m_contentSize >= this.m_bufferSize) {
            int n = 0;
            int n2 = this.m_tail;
            Object[] objectArray = new Object[this.m_bufferSize * 2];
            while (this.m_contentSize > 0) {
                ++n2;
                --this.m_contentSize;
                objectArray[++n] = this.m_buffer[n2 %= this.m_bufferSize];
            }
            this.m_buffer = objectArray;
            this.m_tail = 0;
            this.m_head = n;
            this.m_contentSize = n;
            this.m_bufferSize *= 2;
        }
        this.m_buffer[this.m_head] = object;
        ++this.m_head;
        this.m_head %= this.m_bufferSize;
        ++this.m_contentSize;
    }

    public Object get() {
        if (this.m_contentSize <= 0) {
            return null;
        }
        Object object = this.m_buffer[this.m_tail];
        ++this.m_tail;
        this.m_tail %= this.m_bufferSize;
        --this.m_contentSize;
        return object;
    }
}

