/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Zip;

public class War
extends Jar {
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public void setWarfile(File warFile) {
        super.setZipfile(warFile);
    }

    public void setWebxml(File descr) {
        this.deploymentDescriptor = descr;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        Zip.PrefixedFileSet fs = new Zip.PrefixedFileSet();
        fs.setDir(new File(this.deploymentDescriptor.getParent()));
        fs.setIncludes(this.deploymentDescriptor.getName());
        fs.setFullpath("WEB-INF/web.xml");
        super.addFileset(fs);
    }

    public void addLib(Zip.PrefixedFileSet fs) {
        fs.setPrefix("WEB-INF/lib/");
        super.addFileset(fs);
    }

    public void addClasses(Zip.PrefixedFileSet fs) {
        fs.setPrefix("WEB-INF/classes/");
        super.addFileset(fs);
    }

    public void addWebinf(Zip.PrefixedFileSet fs) {
        fs.setPrefix("WEB-INF/");
        super.addFileset(fs);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.deploymentDescriptor == null) {
            throw new BuildException("webxml attribute is required", this.location);
        }
        super.initZipOutputStream(zOut);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (vPath.equalsIgnoreCase("WEB-INF/web.xml")) {
            if (this.deploymentDescriptor == null || !this.deploymentDescriptor.equals(file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a WEB-INF/web.xml which will be ignored " + "(please use webxml attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zOut, vPath);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zOut, vPath);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }

    public War() {
        this.archiveType = "war";
        this.emptyBehavior = "create";
    }
}

