/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher launcher = Execute.createCommandLauncher();
    private static Vector procEnvironment = null;
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private static /* synthetic */ Class array$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$io$File;
    private static /* synthetic */ Class class$Ljava$lang$Runtime;

    private static CommandLauncher createCommandLauncher() {
        try {
            return new Java13CommandLauncher();
        }
        catch (NoSuchMethodException exc) {
            String osname = System.getProperty("os.name").toLowerCase();
            if (osname.indexOf("mac os") >= 0) {
                return new MacCommandLauncher(new CommandLauncher());
            }
            if (osname.indexOf("os/2") >= 0) {
                return new WinNTCommandLauncher(new CommandLauncher());
            }
            if (osname.indexOf("windows") >= 0) {
                CommandLauncher baseLauncher;
                if (System.getProperty("java.version").startsWith("1.1")) {
                    Java11CommandLauncher java11CommandLauncher = new Java11CommandLauncher();
                } else {
                    baseLauncher = new CommandLauncher();
                }
                if (osname.indexOf("nt") >= 0 || osname.indexOf("2000") >= 0) {
                    return new WinNTCommandLauncher(baseLauncher);
                }
                return new ScriptCommandLauncher("bin/antRun.bat", baseLauncher);
            }
            return new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Execute exe = new Execute(new PumpStreamHandler(out));
            exe.setCommandline(Execute.getProcEnvCommand());
            exe.setNewenvironment(true);
            int retval = exe.execute();
            if (retval != 0) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new StringReader(out.toString()));
            while ((line = in.readLine()) != null) {
                void var4_5;
                procEnvironment.addElement(var4_5);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("mac os") >= 0) {
            String[] cmd = null;
            return cmd;
        }
        if (osname.indexOf("os/2") >= 0) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (osname.indexOf("indows") >= 0) {
            if (osname.indexOf("nt") >= 0 || osname.indexOf("2000") >= 0) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        String[] cmd = new String[]{"/usr/bin/env"};
        return cmd;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] commandline) {
        this.cmdl = commandline;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public void setWorkingDirectory(File wd) {
        this.workingDirectory = wd == null || wd.getAbsolutePath().equals(antWorkingDirectory) ? null : wd;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public int execute() throws IOException {
        Process process = launcher.exec(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        this.streamHandler.start();
        if (this.watchdog != null) {
            this.watchdog.start(process);
        }
        this.waitFor(process);
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        this.streamHandler.stop();
        if (this.watchdog != null) {
            this.watchdog.checkException();
        }
        return this.getExitValue();
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setExitValue(int value) {
        this.exitValue = value;
    }

    protected int getExitValue() {
        return this.exitValue;
    }

    private String[] patchEnvironment() {
        Vector osEnv = (Vector)Execute.getProcEnvironment().clone();
        int i = 0;
        while (i < this.env.length) {
            int pos = this.env[i].indexOf(61);
            String key = this.env[i].substring(0, pos + 1);
            int size = osEnv.size();
            int j = 0;
            while (j < size) {
                if (((String)osEnv.elementAt(j)).startsWith(key)) {
                    osEnv.removeElementAt(j);
                    break;
                }
                ++j;
            }
            osEnv.addElement(this.env[i]);
            ++i;
        }
        Object[] result = new String[osEnv.size()];
        osEnv.copyInto(result);
        return result;
    }

    public static void runCommand(Task task, String[] cmdline) throws BuildException {
        try {
            task.log(Commandline.toString(cmdline), 3);
            Execute exe = new Execute(new LogStreamHandler(task, 2, 0));
            exe.setAntRun(task.getProject());
            exe.setCommandline(cmdline);
            int retval = exe.execute();
            if (retval != 0) {
                throw new BuildException(cmdline[0] + " failed with return code " + retval, task.getLocation());
            }
        }
        catch (IOException exc) {
            throw new BuildException("Could not launch " + cmdline[0] + ": " + exc, task.getLocation());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler streamHandler) {
        this(streamHandler, null);
    }

    public Execute(ExecuteStreamHandler streamHandler, ExecuteWatchdog watchdog) {
        this.streamHandler = streamHandler;
        this.watchdog = watchdog;
    }

    private static class CommandLauncher {
        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            return Runtime.getRuntime().exec(cmd, env);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }

        CommandLauncher() {
        }
    }

    private static class Java11CommandLauncher
    extends CommandLauncher {
        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            String[] newcmd = new String[cmd.length];
            int i = 0;
            while (i < cmd.length) {
                newcmd[i] = Commandline.quoteArgument(cmd[i]);
                ++i;
            }
            return Runtime.getRuntime().exec(newcmd, env);
        }

        Java11CommandLauncher() {
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method _execWithCWD;

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            try {
                Object[] arguments = new Object[]{cmd, env, workingDir};
                return (Process)this._execWithCWD.invoke((Object)Runtime.getRuntime(), arguments);
            }
            catch (InvocationTargetException exc) {
                Throwable realexc = exc.getTargetException();
                if (realexc instanceof ThreadDeath) {
                    throw (ThreadDeath)realexc;
                }
                if (realexc instanceof IOException) {
                    throw (IOException)realexc;
                }
                throw new IOException(realexc.getMessage());
            }
            catch (Exception exc) {
                throw new IOException(exc.getMessage());
            }
        }

        public Java13CommandLauncher() throws NoSuchMethodException {
            Class clazz;
            Class clazz2;
            Class clazz3;
            Class clazz4;
            if (class$Ljava$lang$Runtime != null) {
                clazz4 = class$Ljava$lang$Runtime;
            } else {
                Class clazz5 = Execute.class$("java.lang.Runtime");
                clazz4 = clazz5;
                class$Ljava$lang$Runtime = clazz5;
            }
            Class[] classArray = new Class[3];
            if (array$Ljava$lang$String != null) {
                clazz3 = array$Ljava$lang$String;
            } else {
                Class clazz6 = Execute.class$("[Ljava.lang.String;");
                clazz3 = clazz6;
                array$Ljava$lang$String = clazz6;
            }
            classArray[0] = clazz3;
            if (array$Ljava$lang$String != null) {
                clazz2 = array$Ljava$lang$String;
            } else {
                Class clazz7 = Execute.class$("[Ljava.lang.String;");
                clazz2 = clazz7;
                array$Ljava$lang$String = clazz7;
            }
            classArray[1] = clazz2;
            if (class$Ljava$io$File != null) {
                clazz = class$Ljava$io$File;
            } else {
                Class clazz8 = Execute.class$("java.io.File");
                clazz = clazz8;
                class$Ljava$io$File = clazz8;
            }
            classArray[2] = clazz;
            this._execWithCWD = clazz4.getMethod("exec", classArray);
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher _launcher;

        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            return this._launcher.exec(project, cmd, env);
        }

        CommandLauncherProxy(CommandLauncher launcher) {
            this._launcher = launcher;
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            String[] newcmd = new String[cmd.length + 5];
            newcmd[0] = "cmd";
            newcmd[1] = "/c";
            newcmd[2] = "cd";
            newcmd[3] = workingDir.getAbsolutePath();
            newcmd[4] = "&&";
            System.arraycopy(cmd, 0, newcmd, 5, cmd.length);
            return this.exec(project, newcmd, env);
        }

        WinNTCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            Process process;
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            ((Hashtable)System.getProperties()).put("user.dir", workingDir.getAbsolutePath());
            try {
                process = this.exec(project, cmd, env);
                Object var6_6 = null;
                ((Hashtable)System.getProperties()).put("user.dir", antWorkingDirectory);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ((Hashtable)System.getProperties()).put("user.dir", antWorkingDirectory);
                throw throwable;
            }
            return process;
        }

        MacCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String _script;

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            if (project == null) {
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String antHome = project.getProperty("ant.home");
            if (antHome == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String antRun = project.resolveFile(antHome + File.separator + this._script).toString();
            String[] newcmd = new String[cmd.length + 2];
            newcmd[0] = antRun;
            newcmd[1] = workingDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 2, cmd.length);
            return this.exec(project, newcmd, env);
        }

        ScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this._script = script;
        }
    }
}

