/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.camelot.Info;
import org.apache.avalon.camelot.Registry;
import org.apache.avalon.camelot.RegistryException;

public class DefaultRegistry
implements Registry {
    protected final HashMap m_infos = new HashMap();
    protected final Class m_infoClass;

    public DefaultRegistry(Class clazz) {
        this.m_infoClass = clazz;
    }

    public void register(String string, Info info) throws RegistryException {
        if (null != this.m_infos.get(string)) {
            throw new RegistryException("Name " + string + " already registered");
        }
        this.checkInfo(string, info);
        this.m_infos.put(string, info);
    }

    public void unregister(String string) throws RegistryException {
        if (null == this.m_infos.remove(string)) {
            throw new RegistryException("Name " + string + " not registered");
        }
    }

    public Info getInfo(String string) throws RegistryException {
        Info info = (Info)this.m_infos.get(string);
        if (null == info) {
            throw new RegistryException("Name " + string + " not registered");
        }
        return info;
    }

    public Iterator getInfoNames() {
        return this.m_infos.keySet().iterator();
    }

    protected void checkInfo(String string, Info info) throws RegistryException {
        if (!this.m_infoClass.isAssignableFrom(info.getClass())) {
            throw new RegistryException("Only Infos of type " + this.m_infoClass.getName() + " may be placed in registry.");
        }
    }
}

