/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import org.apache.xalan.transformer.KeyIterator;
import org.apache.xalan.transformer.KeyWalker;
import org.apache.xml.utils.QName;
import org.apache.xpath.NodeSet;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class KeyRefIterator
extends LocPathIterator {
    private QName m_name;
    private String m_lookupKey;
    private KeyIterator m_ki;

    public KeyRefIterator(String string, KeyIterator keyIterator) {
        super(keyIterator.getPrefixResolver());
        this.setShouldCacheNodes(true);
        this.m_ki = keyIterator;
        this.m_name = keyIterator.getName();
        this.m_lookupKey = string;
        this.m_execContext = keyIterator.getXPathContext();
        this.m_dhelper = keyIterator.getDOMHelper();
    }

    public void addNode(Node node) {
        NodeSet nodeSet = this.getCachedNodes();
        if (nodeSet != null && !nodeSet.contains(node)) {
            nodeSet.addElement(node);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        KeyRefIterator keyRefIterator = (KeyRefIterator)super.clone();
        return keyRefIterator;
    }

    public QName getName() {
        return this.m_name;
    }

    public Node nextNode() throws DOMException {
        if (this.m_foundLast) {
            return null;
        }
        NodeSet nodeSet = this.getCachedNodes();
        if (nodeSet != null && this.m_next < nodeSet.size()) {
            Node node = nodeSet.elementAt(this.m_next);
            this.setCurrentPos(++this.m_next);
            this.m_lastFetched = node;
            return node;
        }
        Node node = null;
        if (this.m_ki.getLookForMoreNodes()) {
            ((KeyWalker)this.m_ki.getFirstWalker()).m_lookupKey = this.m_lookupKey;
            node = this.m_ki.nextNode();
        }
        if (node != null) {
            this.m_lastFetched = node;
            this.setCurrentPos(++this.m_next);
            return node;
        }
        this.m_foundLast = true;
        this.m_lastFetched = null;
        return null;
    }

    public void reset() {
        super.reset();
        this.setCurrentPos(0);
    }
}

