/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.junit3;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.ant.antunit.AntUnitExecutionNotifier;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.junit3.AntUnitTestCase;

class JUnitNotificationAdapter
implements AntUnitExecutionNotifier {
    private final TestResult junitTestResult;
    private Map testByTarget = new HashMap();

    public JUnitNotificationAdapter(TestResult testResult, Enumeration tests) {
        this.junitTestResult = testResult;
        while (tests.hasMoreElements()) {
            AntUnitTestCase test = (AntUnitTestCase)((Object)tests.nextElement());
            this.testByTarget.put(test.getTarget(), test);
        }
    }

    public void fireStartTest(String targetName) {
        this.junitTestResult.startTest((Test)this.testByTarget.get(targetName));
    }

    public void fireEndTest(String targetName) {
        this.junitTestResult.endTest((Test)this.testByTarget.get(targetName));
    }

    public void fireError(String targetName, Throwable t) {
        this.junitTestResult.addError((Test)this.testByTarget.get(targetName), t);
    }

    public void fireFail(String targetName, AssertionFailedException ae) {
        this.junitTestResult.addError((Test)this.testByTarget.get(targetName), (Throwable)((Object)ae));
    }
}

