/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.pool;

import org.apache.avalon.Poolable;
import org.apache.avalon.ThreadSafe;
import org.apache.avalon.util.pool.AbstractPool;
import org.apache.avalon.util.pool.DefaultObjectFactory;
import org.apache.avalon.util.pool.ObjectFactory;
import org.apache.avalon.util.pool.PoolController;

public class ThreadSafePool
extends AbstractPool
implements ThreadSafe {
    public static final int DEFAULT_POOL_SIZE = 8;
    protected boolean m_blocking = false;

    public final boolean isBlocking() {
        return this.m_blocking;
    }

    public final void setBlocking(boolean blocking) {
        this.m_blocking = blocking;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Poolable get() throws Exception {
        Poolable[] poolableArray = this.m_pool;
        synchronized (poolableArray) {
            if (this.m_count == 0) {
                if (!this.m_blocking) {
                    return this.m_factory.newInstance();
                }
                while (this.m_count == 0) {
                    try {
                        this.m_pool.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            --this.m_count;
            Poolable poolable = this.m_pool[this.m_count];
            this.m_pool[this.m_count] = null;
            return poolable;
        }
    }

    public final void put(Poolable poolable) {
        Poolable[] poolableArray = this.m_pool;
        synchronized (poolableArray) {
            super.put(poolable);
            this.m_pool.notifyAll();
        }
    }

    public ThreadSafePool(ObjectFactory factory, PoolController controller) throws Exception {
        super(factory, controller, 8, 8);
    }

    public ThreadSafePool(ObjectFactory factory) throws Exception {
        this(factory, null);
    }

    public ThreadSafePool(ObjectFactory factory, int initial, int maximum) throws Exception {
        super(factory, null, initial, maximum);
    }

    public ThreadSafePool(ObjectFactory factory, int initial) throws Exception {
        this(factory, initial, initial);
    }

    public ThreadSafePool(Class clazz, int initial, int maximum) throws NoSuchMethodException, Exception {
        this(new DefaultObjectFactory(clazz), initial, maximum);
    }

    public ThreadSafePool(Class clazz, int initial) throws NoSuchMethodException, Exception {
        this(clazz, initial, initial);
    }
}

