/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapterFactory;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Rmic
extends MatchingTask {
    private static final String FAIL_MSG = "Rmic failed, messages should have been provided.";
    private File baseDir;
    private String classname;
    private File sourceBase;
    private String stubVersion;
    private Path compileClasspath;
    private Path extdirs;
    private boolean verify = false;
    private boolean filtering = false;
    private boolean iiop = false;
    private String iiopopts;
    private boolean idl = false;
    private String idlopts;
    private boolean debug = false;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private Vector compileList = new Vector();
    private ClassLoader loader = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setBase(File file) {
        this.baseDir = file;
    }

    public File getBase() {
        return this.baseDir;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setSourceBase(File file) {
        this.sourceBase = file;
    }

    public File getSourceBase() {
        return this.sourceBase;
    }

    public void setStubVersion(String string) {
        this.stubVersion = string;
    }

    public String getStubVersion() {
        return this.stubVersion;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public boolean getFiltering() {
        return this.filtering;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public boolean getIiop() {
        return this.iiop;
    }

    public void setIiopopts(String string) {
        this.iiopopts = string;
    }

    public String getIiopopts() {
        return this.iiopopts;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public boolean getIdl() {
        return this.idl;
    }

    public void setIdlopts(String string) {
        this.idlopts = string;
    }

    public String getIdlopts() {
        return this.idlopts;
    }

    public Vector getFileList() {
        return this.compileList;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setExtdirs(Path path) {
        if (this.extdirs == null) {
            this.extdirs = path;
        } else {
            this.extdirs.append(path);
        }
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.project);
        }
        return this.extdirs.createPath();
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Vector getCompileList() {
        return this.compileList;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("base attribute must be set!", this.location);
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("base does not exist!", this.location);
        }
        if (this.verify) {
            this.log("Verify has been turned on.", 2);
        }
        String string = this.project.getProperty("build.rmic");
        RmicAdapter rmicAdapter = RmicAdapterFactory.getRmic(string, this);
        rmicAdapter.setRmic(this);
        Path path = rmicAdapter.getClasspath();
        this.loader = new AntClassLoader(this.project, path);
        if (this.classname == null) {
            DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.scanDir(this.baseDir, stringArray, rmicAdapter.getMapper());
        } else {
            this.scanDir(this.baseDir, new String[]{this.classname.replace('.', File.separatorChar) + ".class"}, rmicAdapter.getMapper());
        }
        int n = this.compileList.size();
        if (n > 0) {
            this.log("RMI Compiling " + n + " class" + (n > 1 ? "es" : "") + " to " + this.baseDir, 2);
            if (!rmicAdapter.execute()) {
                throw new BuildException(FAIL_MSG, this.location);
            }
        }
        if (null != this.sourceBase && !this.baseDir.equals(this.sourceBase)) {
            if (this.idl) {
                this.log("Cannot determine sourcefiles in idl mode, ", 1);
                this.log("sourcebase attribute will be ignored.", 1);
            } else {
                int n2 = 0;
                while (n2 < n) {
                    this.moveGeneratedFile(this.baseDir, this.sourceBase, (String)this.compileList.elementAt(n2), rmicAdapter);
                    ++n2;
                }
            }
        }
        this.compileList.removeAllElements();
    }

    private void moveGeneratedFile(File file, File file2, String string, RmicAdapter rmicAdapter) throws BuildException {
        String string2 = string.replace('.', File.separatorChar) + ".class";
        String[] stringArray = rmicAdapter.getMapper().mapFileName(string2);
        int n = 0;
        while (n < stringArray.length) {
            String string3 = string2.substring(0, string2.length() - 6) + ".java";
            File file3 = new File(file, string3);
            File file4 = new File(file2, string3);
            try {
                this.project.copyFile(file3, file4, this.filtering);
                file3.delete();
            }
            catch (IOException iOException) {
                String string4 = "Failed to copy " + file3 + " to " + file4 + " due to " + iOException.getMessage();
                throw new BuildException(string4, iOException, this.location);
            }
            ++n;
        }
    }

    protected void scanDir(File file, String[] stringArray, FileNameMapper fileNameMapper) {
        String[] stringArray2 = stringArray;
        if (this.idl) {
            this.log("will leave uptodate test to rmic implementation in idl mode.", 3);
        } else if (this.iiop && this.iiopopts != null && this.iiopopts.indexOf("-always") > -1) {
            this.log("no uptodate test as -always option has been specified", 3);
        } else {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            stringArray2 = sourceFileScanner.restrict(stringArray, file, file, fileNameMapper);
        }
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n].replace(File.separatorChar, '.');
            string = string.substring(0, string.lastIndexOf(".class"));
            this.compileList.addElement(string);
            ++n;
        }
    }

    public boolean isValidRmiRemote(String string) {
        try {
            Class<?> clazz = this.loader.loadClass(string);
            if (clazz.isInterface() && !this.iiop && !this.idl) {
                return false;
            }
            return this.isValidRmiRemote(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Unable to verify class " + string + ". It could not be found.", 1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log("Unable to verify class " + string + ". It is not defined.", 1);
        }
        catch (Throwable throwable) {
            this.log("Unable to verify class " + string + ". Loading caused Exception: " + throwable.getMessage(), 1);
        }
        return false;
    }

    public Class getRemoteInterface(Class clazz) {
        Class<?>[] classArray;
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = Rmic.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz) && (classArray = clazz.getInterfaces()) != null) {
            int n = 0;
            while (n < classArray.length) {
                if ((class$java$rmi$Remote == null ? Rmic.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[n])) {
                    return classArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    private boolean isValidRmiRemote(Class clazz) {
        return this.getRemoteInterface(clazz) != null;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

