/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResettableFileInputStream
extends InputStream {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final String m_filename;
    protected int m_bufferSize;
    protected InputStream m_inputStream;
    protected long m_position;
    protected long m_mark;
    protected boolean m_isMarkSet;

    public ResettableFileInputStream(File file) throws IOException {
        this(file.getCanonicalPath());
    }

    public ResettableFileInputStream(String string) throws IOException {
        this(string, 1024);
    }

    public ResettableFileInputStream(String string, int n) throws IOException {
        this.m_bufferSize = n;
        this.m_filename = string;
        this.m_position = 0L;
        this.m_inputStream = this.newStream();
    }

    public void mark(int n) {
        this.m_isMarkSet = true;
        this.m_mark = this.m_position;
        this.m_inputStream.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        if (!this.m_isMarkSet) {
            throw new IOException("Unmarked Stream");
        }
        try {
            this.m_inputStream.reset();
        }
        catch (IOException iOException) {
            try {
                this.m_inputStream.close();
                this.m_inputStream = this.newStream();
                this.m_inputStream.skip(this.m_mark);
                this.m_position = this.m_mark;
            }
            catch (Exception exception) {
                throw new IOException("Cannot reset current Stream: " + exception.getMessage());
            }
        }
    }

    protected InputStream newStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.m_filename), this.m_bufferSize);
    }

    public int available() throws IOException {
        return this.m_inputStream.available();
    }

    public void close() throws IOException {
        this.m_inputStream.close();
    }

    public int read() throws IOException {
        ++this.m_position;
        return this.m_inputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_inputStream.read(byArray, n, n2);
        this.m_position += (long)n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        this.m_position += l;
        return this.m_inputStream.skip(l);
    }
}

