/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.tags.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.Log;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;

public class ConstructorTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$tags$ConstructorTagsHandler;

    protected static boolean hasConstructor(ClassDoc clazz, String constructorName, String[] parameters) {
        Category cat = Log.getCategory(class$xdoclet$tags$ConstructorTagsHandler == null ? (class$xdoclet$tags$ConstructorTagsHandler = ConstructorTagsHandler.class$("xdoclet.tags.ConstructorTagsHandler")) : class$xdoclet$tags$ConstructorTagsHandler, "hasConstructor");
        while (clazz != null) {
            ConstructorDoc[] constructors = clazz.constructors();
            int i = 0;
            while (i < constructors.length) {
                block5: {
                    if (constructors[i].name().equals(constructorName)) {
                        Parameter[] params = constructors[i].parameters();
                        cat.debug((Object)("params.length=" + params.length));
                        int j = 0;
                        while (j < params.length) {
                            cat.debug((Object)("params[j].typeName()=" + params[j].typeName()));
                            cat.debug((Object)("parameters[j]=" + parameters[j]));
                            if (parameters != null && params[j].typeName().equals(parameters[j])) {
                                ++j;
                                continue;
                            }
                            break block5;
                        }
                        return true;
                    }
                }
                ++i;
            }
            clazz = clazz.superclass();
        }
        return false;
    }

    public void setCurrentConstructor(String template, Properties attributes) throws XDocletException {
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        ConstructorDoc oldConstructor = this.getCurrentConstructor();
        if (this.hasConstructor(this.getCurrentClass(), constructorName, parameters, true)) {
            this.generate(template);
        }
        this.setCurrentConstructor(oldConstructor);
    }

    public String constructorComment(Properties attributes) throws XDocletException {
        String no_comment_signs = attributes.getProperty("no-comment-signs");
        if (no_comment_signs != null && no_comment_signs.equalsIgnoreCase("true")) {
            return this.getCurrentConstructor().commentText();
        }
        char[] spaces = this.getIndentChars(attributes);
        Tag[] constructor_tags = this.getCurrentConstructor().tags();
        if (constructor_tags.length > 0) {
            StringBuffer result = new StringBuffer();
            StringTokenizer st = new StringTokenizer(this.getCurrentConstructor().commentText().trim(), "\n", false);
            if (st.countTokens() > 0) {
                result.append(spaces).append("/**").append("\n");
                while (st.hasMoreTokens()) {
                    result.append(spaces).append(" * ").append(st.nextToken().trim()).append("\n");
                }
                int i = 0;
                while (i < constructor_tags.length) {
                    if (constructor_tags[i].name().lastIndexOf(58) == -1) {
                        result.append(spaces).append(" * ").append(constructor_tags[i].name()).append(' ').append(constructor_tags[i].text());
                        if (i < constructor_tags.length - 1) {
                            result.append("\n");
                        }
                    }
                    ++i;
                }
                result.append(spaces).append(" */");
            }
            return result.toString();
        }
        return "";
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        String skip_exceptions = attributes.getProperty("skip");
        String append_exceptions = attributes.getProperty("append");
        String constructor_name = attributes.getProperty("constructor");
        ClassDoc[] exceptions = null;
        if (this.getCurrentConstructor() == null && constructor_name == null) {
            return "";
        }
        if (constructor_name == null) {
            exceptions = this.getCurrentConstructor().thrownExceptions();
        } else {
            ConstructorDoc constructor_doc = this.getConstructorDocForConstructorName(constructor_name, true);
            if (constructor_doc == null) {
                return "";
            }
            exceptions = constructor_doc.thrownExceptions();
        }
        StringBuffer st = new StringBuffer();
        String type = null;
        int i = 0;
        while (i < exceptions.length) {
            type = exceptions[i].toString();
            if (!this.isInSkipExceptionsList(skip_exceptions, type) && !this.isInAppendExceptionsList(append_exceptions, type)) {
                this.appendException(st, type);
            }
            ++i;
        }
        if (append_exceptions != null) {
            this.appendException(st, append_exceptions);
        }
        return st.toString();
    }

    public void forAllClassConstructors(String template, Properties attributes) throws XDocletException {
        String type_name = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        ClassDoc[] classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet<ConstructorDoc> constructors = new TreeSet<ConstructorDoc>();
        int i = 0;
        while (i < classes.length) {
            if (type_name == null || TypeTagsHandler.isOfType((Type)classes[i], type_name, extent)) {
                ConstructorDoc[] classConstructors = classes[i].constructors();
                int j = 0;
                while (j < classConstructors.length) {
                    constructors.add(classConstructors[j]);
                    ++j;
                }
            }
            ++i;
        }
        Iterator constructorsIterator = constructors.iterator();
        while (constructorsIterator.hasNext()) {
            ConstructorDoc current = (ConstructorDoc)constructorsIterator.next();
            this.setCurrentClass(current.containingClass());
            this.setCurrentConstructor(current);
            this.generate(template);
        }
    }

    public void forAllConstructors(String template, Properties attributes) throws XDocletException {
        boolean superclasses = TypeConversionUtil.stringToBoolean(attributes.getProperty("superclasses"), true);
        boolean sort = TypeConversionUtil.stringToBoolean(attributes.getProperty("sort"), true);
        ClassDoc cur_class = this.getCurrentClass();
        ArrayList<ConstructorDoc> already = new ArrayList<ConstructorDoc>();
        do {
            ConstructorDoc[] constructors = cur_class.constructors();
            Object constructorFound = null;
            if (sort) {
                List<ConstructorDoc> the_list = Arrays.asList(constructors);
                Collections.sort(the_list, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ConstructorDoc m1 = (ConstructorDoc)o1;
                        ConstructorDoc m2 = (ConstructorDoc)o2;
                        return m1.name().compareTo(m2.name());
                    }

                    public boolean equals(Object obj) {
                        return obj == this;
                    }
                });
                constructors = the_list.toArray(constructors);
            }
            int j = 0;
            while (j < constructors.length) {
                if (!superclasses || superclasses && constructors[j].containingClass() == cur_class) {
                    Iterator i = already.iterator();
                    boolean contained = false;
                    while (i.hasNext()) {
                        if (((ConstructorDoc)i.next()).compareTo((Object)constructors[j]) == 0) {
                            contained = true;
                        }
                        if (contained) break;
                    }
                    if (!contained) {
                        this.setCurrentConstructor(constructors[j]);
                        already.add(constructors[j]);
                        this.generate(template);
                    }
                }
                ++j;
            }
        } while (superclasses && (cur_class = cur_class.superclass()) != null);
    }

    public void ifDoesntHaveConstructorTag(String template, Properties attributes) throws XDocletException {
        if (!this.ifHasTag_Impl(template, attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasConstructorTag(String template, Properties attributes) throws XDocletException {
        if (this.ifHasTag_Impl(template, attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreConstructor(String template, Properties attributes) throws XDocletException {
        ConstructorDoc constructor = this.getCurrentConstructor();
        this.generate(template);
        this.setCurrentConstructor(constructor);
    }

    public void ifConstructorTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (this.ifTagValueEquals_Impl(template, attributes, 3)) {
            this.generate(template);
        }
    }

    public void ifConstructorTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!this.ifTagValueEquals_Impl(template, attributes, 3)) {
            this.generate(template);
        }
    }

    public String constructorTagValue(Properties attributes) throws XDocletException {
        return this.getTagValue(attributes, 3);
    }

    public void forAllConstructorTags(String template, Properties attributes) throws XDocletException {
        if (this.getCurrentConstructor() == null) {
            throw new XDocletException(Translator.getString("only_call_constructor_not_null", new String[]{"forAllConstructorTags"}));
        }
        Tag[] tags = this.getCurrentConstructor().tags(attributes.getProperty("tagName"));
        int i = 0;
        while (i < tags.length) {
            this.setCurrentTag(tags[i]);
            String m = this.getTagValue(attributes, 3);
            if (AbstractProgramElementTagsHandler.matchPattern == null) {
                this.generate(template);
            } else if (AbstractProgramElementTagsHandler.matchPattern != null && (AbstractProgramElementTagsHandler.matchPattern.equals(m) || m.equals("*"))) {
                this.generate(template);
            }
            ++i;
        }
        this.setCurrentTag(null);
    }

    public void forAllConstructorTagTokens(String template, Properties attributes) throws XDocletException {
        int skip;
        Category cat = Log.getCategory(class$xdoclet$tags$ConstructorTagsHandler == null ? (class$xdoclet$tags$ConstructorTagsHandler = ConstructorTagsHandler.class$("xdoclet.tags.ConstructorTagsHandler")) : class$xdoclet$tags$ConstructorTagsHandler, "forAllConstructorTagTokens");
        String tagValue = this.getTagValue(attributes, 3);
        String delimiter = attributes.getProperty("delimiter");
        String s = attributes.getProperty("skip");
        try {
            skip = Integer.valueOf(attributes.getProperty("skip"));
        }
        catch (Throwable t) {
            skip = 0;
        }
        if (delimiter == null) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"got null delimiter - forAllConstructorTagTokens");
            }
            delimiter = ",";
        }
        AbstractProgramElementTagsHandler.tagTokenizer = new StringTokenizer(tagValue, delimiter, false);
        AbstractProgramElementTagsHandler.currentToken = "";
        AbstractProgramElementTagsHandler.matchPattern = null;
        int i = 0;
        while (AbstractProgramElementTagsHandler.tagTokenizer.hasMoreTokens() && i < skip) {
            AbstractProgramElementTagsHandler.tagTokenizer.nextToken();
            ++i;
        }
        while (AbstractProgramElementTagsHandler.tagTokenizer.hasMoreTokens()) {
            AbstractProgramElementTagsHandler.currentToken = AbstractProgramElementTagsHandler.tagTokenizer.nextToken();
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("generate current token: " + AbstractProgramElementTagsHandler.currentToken));
            }
            this.generate(template);
        }
        AbstractProgramElementTagsHandler.currentToken = null;
        AbstractProgramElementTagsHandler.tagTokenizer = null;
        AbstractProgramElementTagsHandler.matchPattern = null;
    }

    public String firstSentenceDescriptionOfCurrentConstructor() throws XDocletException {
        return this.getCurrentConstructor().firstSentenceTags().length > 0 ? this.getCurrentConstructor().firstSentenceTags()[0].text().trim() : "";
    }

    public String constructorName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)((Hashtable)attributes).get("value")) != null) {
            String m = this.getCurrentConstructor().name().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return this.getCurrentConstructor() != null ? this.getCurrentConstructor().name() : "";
    }

    public String currentConstructorName() throws XDocletException {
        return this.getCurrentConstructor().name();
    }

    public void ifHasConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, true);
    }

    public void ifDoesntHaveConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, false);
    }

    protected ConstructorDoc getConstructorDocForConstructorName(String constructorName) {
        if (constructorName != null) {
            return this.extractConstructorDoc(this.getCurrentClass(), constructorName);
        }
        return null;
    }

    protected ConstructorDoc getConstructorDocForConstructorName(String constructorName, boolean superclasses) {
        if (!superclasses) {
            return this.getConstructorDocForConstructorName(constructorName);
        }
        ClassDoc clazz = this.getCurrentClass();
        while (clazz != null) {
            ConstructorDoc constructor = this.extractConstructorDoc(clazz, constructorName);
            if (constructor != null) {
                return constructor;
            }
            clazz = clazz.superclass();
        }
        return null;
    }

    protected boolean hasConstructor(ClassDoc clazz, String constructorName, String[] parameters, boolean setCurrentConstructor) {
        Category cat = Log.getCategory(class$xdoclet$tags$ConstructorTagsHandler == null ? (class$xdoclet$tags$ConstructorTagsHandler = ConstructorTagsHandler.class$("xdoclet.tags.ConstructorTagsHandler")) : class$xdoclet$tags$ConstructorTagsHandler, "hasConstructor");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("Search for constructor " + constructorName + " in " + clazz.name()));
        }
        while (clazz != null) {
            ConstructorDoc[] constructors = clazz.constructors();
            int i = 0;
            while (i < constructors.length) {
                block9: {
                    if (constructors[i].name().equals(constructorName)) {
                        Parameter[] params = constructors[i].parameters();
                        int j = 0;
                        while (j < params.length) {
                            if (parameters != null && params[j].typeName().equals(parameters[j])) {
                                ++j;
                                continue;
                            }
                            break block9;
                        }
                        if (cat.isDebugEnabled()) {
                            cat.debug((Object)("Constructor found in " + clazz.name()));
                        }
                        if (setCurrentConstructor) {
                            this.setCurrentConstructor(constructors[i]);
                        }
                        return true;
                    }
                }
                ++i;
            }
            clazz = clazz.superclass();
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)"Constructor not found");
        }
        return false;
    }

    private boolean isInAppendExceptionsList(String append_exceptions, String type) {
        if (append_exceptions == null) {
            return false;
        }
        return append_exceptions.indexOf(type) != -1;
    }

    private boolean isInSkipExceptionsList(String skip_exceptions, String type) {
        if (skip_exceptions == null) {
            return false;
        }
        return skip_exceptions.indexOf(type) != -1;
    }

    private ConstructorDoc extractConstructorDoc(ClassDoc clazz, String constructorName) {
        ConstructorDoc[] constructors = clazz.constructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].name().equals(constructorName)) {
                return constructors[i];
            }
            ++i;
        }
        return null;
    }

    private void appendException(StringBuffer st, String type) {
        if (st.length() == 0) {
            st.append("throws ");
        } else {
            st.append(", ");
        }
        st.append(type);
    }

    private void ifHasConstructor_Impl(String template, Properties attributes, boolean has_constructor) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$ConstructorTagsHandler == null ? (class$xdoclet$tags$ConstructorTagsHandler = ConstructorTagsHandler.class$("xdoclet.tags.ConstructorTagsHandler")) : class$xdoclet$tags$ConstructorTagsHandler, "ifHasConstructor_Impl");
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("constructorName=" + constructorName));
            cat.debug((Object)("parametersStr=" + parametersStr));
            cat.debug((Object)("delimiter=" + delimiter));
            cat.debug((Object)("has_constructor=" + has_constructor));
            cat.debug((Object)("getCurrentClass()=" + this.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("parameters.length=" + parameters.length));
                cat.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (this.hasConstructor(this.getCurrentClass(), constructorName, parameters, false) == has_constructor) {
            if (cat.isDebugEnabled()) {
                cat.debug((Object)"constructor found.");
            }
            this.generate(template);
        } else if (cat.isDebugEnabled()) {
            cat.debug((Object)"constructor not found.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

