/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class WeblogicDeploymentTool
extends GenericDeploymentTool {
    protected static final String WL_DD = "weblogic-ejb-jar.xml";
    protected static final String WL_CMP_DD = "weblogic-cmp-rdbms-jar.xml";
    protected static final String WL_DTD = "/weblogic/ejb/deployment/xml/ejb-jar.dtd";
    protected static final String WL_HTTP_DTD = "http://www.bea.com/servers/wls510/dtd/weblogic-ejb-jar.dtd";
    private String jarSuffix = ".jar";
    private String weblogicDTD;
    private Path classpath;
    private boolean keepgenerated = false;
    private String additionalArgs = "";
    private boolean keepGeneric = false;
    private String compiler = null;

    protected void addVendorFiles(Hashtable ejbFiles, String baseName) {
        File weblogicCMPDD;
        String ddPrefix = this.usingBaseJarName() ? "" : String.valueOf(baseName) + this.getBaseNameTerminator();
        File weblogicDD = new File(this.getDescriptorDir(), String.valueOf(ddPrefix) + WL_DD);
        if (weblogicDD.exists()) {
            ejbFiles.put("META-INF/weblogic-ejb-jar.xml", weblogicDD);
        }
        if ((weblogicCMPDD = new File(this.getDescriptorDir(), String.valueOf(ddPrefix) + WL_CMP_DD)).exists()) {
            ejbFiles.put("META-INF/weblogic-cmp-rdbms-jar.xml", weblogicCMPDD);
        }
    }

    private void buildWeblogicJar(File sourceJar, File destJar) {
        Java javaTask = null;
        try {
            String args = this.additionalArgs;
            if (this.keepgenerated) {
                args = String.valueOf(args) + " -keepgenerated";
            }
            if (this.compiler != null) {
                args = String.valueOf(args) + " -compiler " + this.compiler;
            }
            args = String.valueOf(args) + " -noexit " + sourceJar.getPath() + " " + destJar.getPath();
            javaTask = (Java)this.getTask().getProject().createTask("java");
            javaTask.setClassname("weblogic.ejbc");
            Commandline.Argument arguments = javaTask.createArg();
            arguments.setLine(args);
            if (this.classpath != null) {
                javaTask.setClasspath(this.classpath);
                javaTask.setFork(true);
            } else {
                javaTask.setFork(false);
            }
            this.getTask().log("Calling weblogic.ejbc for " + sourceJar.toString(), 3);
            javaTask.execute();
        }
        catch (Exception e) {
            String msg = "Exception while calling ejbc. Details: " + e.toString();
            throw new BuildException(msg, e);
        }
    }

    protected DescriptorHandler getDescriptorHandler(File srcDir) {
        DescriptorHandler handler = new DescriptorHandler(srcDir);
        if (this.weblogicDTD != null) {
            File dtdFile = new File(this.weblogicDTD);
            if (dtdFile.exists()) {
                handler.registerFileDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", dtdFile);
            } else {
                handler.registerResourceDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", this.weblogicDTD);
            }
        } else {
            handler.registerResourceDTD("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", WL_DTD);
        }
        return handler;
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), String.valueOf(baseName) + this.jarSuffix);
    }

    public void setArgs(String args) {
        this.additionalArgs = args;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }

    public void setKeepgenerated(String inValue) {
        this.keepgenerated = Boolean.valueOf(inValue);
    }

    public void setKeepgeneric(boolean inValue) {
        this.keepGeneric = inValue;
    }

    public void setSuffix(String inString) {
        this.jarSuffix = inString;
    }

    public void setWeblogicdtd(String inString) {
        this.weblogicDTD = inString;
    }

    public void validateConfigured() throws BuildException {
        super.validateConfigured();
    }

    protected void writeJar(String baseName, File jarFile, Hashtable files) throws BuildException {
        File genericJarFile = super.getVendorOutputJarFile(baseName);
        super.writeJar(baseName, genericJarFile, files);
        this.buildWeblogicJar(genericJarFile, jarFile);
        if (!this.keepGeneric) {
            this.getTask().log("deleting generic jar " + genericJarFile.toString(), 3);
            genericJarFile.delete();
        }
    }
}

