/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.Node;

public class StepPattern
extends NodeTest
implements SubContextList {
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n) {
        super(n);
    }

    public StepPattern(int n, String string, String string2) {
        super(n, string, string2);
    }

    protected void calcScore() {
        if (this.getPredicateCount() > 0 || this.m_relativePathPattern != null) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    public void calcTargetString() {
        int n = this.getWhatToShow();
        switch (n) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if (this.m_name == "*") {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getPredicate(n2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = this.executeStep(xPathContext);
        if (xObject != NodeTest.SCORE_NONE && this.m_relativePathPattern != null) {
            xObject = this.m_relativePathPattern.executeRelativePathPattern(xPathContext);
        }
        return xObject;
    }

    public XObject executeRelativePathPattern(XPathContext xPathContext) throws TransformerException {
        XObject xObject;
        block4: {
            block3: {
                block2: {
                    Node node = xPathContext.getDOMHelper().getParentOfNode(xPathContext.getCurrentNode());
                    if (node == null) break block3;
                    try {
                        xPathContext.pushCurrentNode(node);
                        xObject = this.execute(xPathContext);
                        if (xObject == NodeTest.SCORE_NONE) break block2;
                        xObject = NodeTest.SCORE_OTHER;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        xPathContext.popCurrentNode();
                        throw throwable;
                    }
                }
                Object var5_4 = null;
                xPathContext.popCurrentNode();
                break block4;
            }
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject executeStep(XPathContext xPathContext) throws TransformerException {
        XObject xObject = super.execute(xPathContext);
        if (xObject == NodeTest.SCORE_NONE) {
            return xObject;
        }
        int n = this.getPredicateCount();
        if (n == 0) {
            return xObject;
        }
        try {
            xPathContext.pushSubContextList(this);
            int n2 = 0;
            while (n2 < n) {
                XObject xObject2 = this.m_predicates[n2].execute(xPathContext);
                if (xObject2.getType() == 2) {
                    if (this.getProximityPosition(xPathContext) != (int)xObject2.num()) {
                        xObject = NodeTest.SCORE_NONE;
                        break;
                    }
                } else if (!xObject2.bool()) {
                    xObject = NodeTest.SCORE_NONE;
                    break;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            xPathContext.popSubContextList();
            throw throwable;
        }
        Object var5_6 = null;
        xPathContext.popSubContextList();
        return xObject;
    }

    public int getLastPos(XPathContext xPathContext) {
        Node node = xPathContext.getCurrentNode();
        Node node2 = xPathContext.getDOMHelper().getParentOfNode(node);
        try {
            try {
                xPathContext.pushCurrentNode(node2);
                int n = 0;
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    Object var10_7;
                    block7: {
                        try {
                            xPathContext.pushCurrentNode(node3);
                            if (NodeTest.SCORE_NONE == super.execute(xPathContext)) break block7;
                            ++n;
                        }
                        catch (Throwable throwable) {
                            var10_7 = null;
                            xPathContext.popCurrentNode();
                            throw throwable;
                        }
                    }
                    var10_7 = null;
                    xPathContext.popCurrentNode();
                    node3 = node3.getNextSibling();
                }
                int n2 = n;
                Object var6_10 = null;
                xPathContext.popCurrentNode();
                return n2;
            }
            catch (TransformerException transformerException) {
                throw new RuntimeException(transformerException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xPathContext.popCurrentNode();
            throw throwable;
        }
    }

    public double getMatchScore(XPathContext xPathContext, Node node) throws TransformerException {
        xPathContext.pushCurrentNode(node);
        xPathContext.pushCurrentExpressionNode(node);
        try {
            XObject xObject = this.execute(xPathContext);
            double d = xObject.num();
            Object var6_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public final int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getProximityPosition(XPathContext xPathContext) {
        Node node = xPathContext.getCurrentNode();
        Node node2 = xPathContext.getDOMHelper().getParentOfNode(node);
        try {
            try {
                xPathContext.pushCurrentNode(node2);
                int n = 0;
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    Object var10_7;
                    block7: {
                        int n2;
                        try {
                            xPathContext.pushCurrentNode(node3);
                            if (NodeTest.SCORE_NONE == super.execute(xPathContext)) break block7;
                            ++n;
                            if (!node3.equals(node)) break block7;
                            n2 = n;
                            var10_7 = null;
                            xPathContext.popCurrentNode();
                        }
                        catch (Throwable throwable) {
                            var10_7 = null;
                            xPathContext.popCurrentNode();
                            throw throwable;
                        }
                        Object var6_9 = null;
                        xPathContext.popCurrentNode();
                        return n2;
                    }
                    var10_7 = null;
                    xPathContext.popCurrentNode();
                    node3 = node3.getNextSibling();
                }
            }
            catch (TransformerException transformerException) {
                throw new RuntimeException(transformerException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xPathContext.popCurrentNode();
            throw throwable;
        }
        Object var6_10 = null;
        xPathContext.popCurrentNode();
        return 0;
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.m_predicates = expressionArray;
        this.calcScore();
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.m_relativePathPattern = stepPattern;
        this.calcScore();
    }
}

