/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class FuncSubstring
extends Function3Args {
    public void checkNumberArgs(int n) throws WrongNumberArgsException {
        if (n < 2) {
            throw new WrongNumberArgsException("2 or 3");
        }
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        String string;
        int n;
        String string2 = this.m_arg0.execute(xPathContext).str();
        double d = this.m_arg1.execute(xPathContext).num();
        int n2 = string2.length();
        if (n2 <= 0) {
            return XString.EMPTYSTRING;
        }
        if (Double.isNaN(d)) {
            d = -1000000.0;
            n = 0;
        } else {
            int n3 = n = (d = (double)Math.round(d)) > 0.0 ? (int)d - 1 : 0;
        }
        if (this.m_arg2 != null) {
            double d2 = this.m_arg2.execute(xPathContext).num();
            int n4 = (int)((double)Math.round(d2) + d) - 1;
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > n2) {
                n4 = n2;
            }
            if (n > n2) {
                n = n2;
            }
            string = string2.substring(n, n4);
        } else {
            if (n > n2) {
                n = n2;
            }
            string = string2.substring(n);
        }
        return new XString(string);
    }
}

