/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.log.LogTarget;

public class DefaultLogTargetManager
extends AbstractLogEnabled
implements LogTargetManager,
LogTargetFactoryManageable,
Contextualizable,
Configurable {
    private final Map m_targets = new HashMap();
    private Context m_context;
    private LogTargetFactoryManager m_factory_manager;

    public final LogTarget getLogTarget(String id) {
        LogTarget logTarget = (LogTarget)this.m_targets.get(id);
        return logTarget;
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public final void setLogTargetFactoryManager(LogTargetFactoryManager logTargetFactoryManager) {
        this.m_factory_manager = logTargetFactoryManager;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_factory_manager == null) {
            throw new ConfigurationException("LogTargetFactory not received");
        }
        Configuration[] confs = configuration.getChildren();
        int i = 0;
        while (i < confs.length) {
            String targetName = confs[i].getName();
            LogTargetFactory logTargetFactory = this.m_factory_manager.getLogTargetFactory(targetName);
            LogTarget logTarget = logTargetFactory.createTarget(confs[i]);
            String targetId = confs[i].getAttribute("id");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("added new LogTarget of id " + targetId);
            }
            this.m_targets.put(targetId, logTarget);
            ++i;
        }
    }
}

