/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.container;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.excalibur.container.Container;
import org.apache.avalon.excalibur.container.ContainerException;
import org.apache.avalon.excalibur.container.Entry;
import org.apache.avalon.framework.logger.AbstractLoggable;

public abstract class AbstractContainer
extends AbstractLoggable
implements Container {
    private final HashMap m_entrys = new HashMap();

    public final void add(String name, Entry entry) throws ContainerException {
        this.checkEntry(name, entry);
        this.preAdd(name, entry);
        this.m_entrys.put(name, entry);
        this.postAdd(name, entry);
    }

    public final void remove(String name) throws ContainerException {
        Entry entry = (Entry)this.m_entrys.get(name);
        if (null == entry) {
            throw new ContainerException("Component named " + name + " not contained");
        }
        this.preRemove(name, entry);
        this.m_entrys.remove(name);
        this.postRemove(name, entry);
    }

    public Entry getEntry(String name) throws ContainerException {
        Entry entry = (Entry)this.m_entrys.get(name);
        if (null == entry) {
            throw new ContainerException("Name " + name + " not contained");
        }
        return entry;
    }

    public final String[] list() {
        return this.m_entrys.keySet().toArray(new String[0]);
    }

    protected void preAdd(String name, Entry entry) throws ContainerException {
    }

    protected void postAdd(String name, Entry entry) {
    }

    protected void preRemove(String name, Entry entry) throws ContainerException {
    }

    protected void postRemove(String name, Entry entry) {
    }

    protected final Iterator listEntries() {
        HashMap clone = new HashMap();
        clone.putAll(this.m_entrys);
        return clone.values().iterator();
    }

    protected final int getEntryCount() {
        return this.m_entrys.size();
    }

    protected void checkEntry(String name, Entry entry) throws ContainerException {
        if (null != this.m_entrys.get(name)) {
            throw new ContainerException("Can not add component to container because entry already exists with name " + name);
        }
    }
}

