/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.filter.PriorityFilter;

public final class PriorityFilterTargetFactory
extends AbstractTargetFactory
implements LogTargetFactoryManageable {
    protected LogTargetFactoryManager m_logTargetFactoryManager;

    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        String loglevel = configuration.getAttribute("log-level", "INFO");
        this.getLogger().debug("loglevel is " + loglevel);
        PriorityFilter filter = new PriorityFilter(Priority.getPriorityForName((String)loglevel));
        Configuration[] configs = configuration.getChildren();
        int i = 0;
        while (i < configs.length) {
            LogTargetFactory factory = this.m_logTargetFactoryManager.getLogTargetFactory(configs[i].getName());
            this.getLogger().debug("creating target " + configs[i].getName() + ": " + configs[i].toString());
            LogTarget logtarget = factory.createTarget(configs[i]);
            filter.addTarget(logtarget);
            ++i;
        }
        return filter;
    }

    public final void setLogTargetFactoryManager(LogTargetFactoryManager logTargetFactoryManager) {
        this.m_logTargetFactoryManager = logTargetFactoryManager;
    }
}

