/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;

public class Path
extends DataType
implements Cloneable {
    private Vector elements;
    private Project project;
    public static Path systemClasspath = new Path(null, System.getProperty("java.class.path"));

    public Path(Project project, String string) {
        this(project);
        this.createPathElement().setPath(string);
    }

    public Path(Project project) {
        this.project = project;
        this.elements = new Vector();
    }

    public void setLocation(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setLocation(file);
    }

    public void setPath(String string) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setPath(string);
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.addElement(reference);
        super.setRefid(reference);
    }

    public PathElement createPathElement() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PathElement pathElement = new PathElement();
        this.elements.addElement(pathElement);
        return pathElement;
    }

    public void addFileset(FileSet fileSet) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fileSet);
        this.checked = false;
    }

    public Path createPath() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path path = new Path(this.project);
        this.elements.addElement(path);
        this.checked = false;
        return path;
    }

    public void append(Path path) {
        if (path == null) {
            return;
        }
        String[] stringArray = path.list();
        int n = 0;
        while (n < stringArray.length) {
            if (this.elements.indexOf(stringArray[n]) == -1) {
                this.elements.addElement(stringArray[n]);
            }
            ++n;
        }
    }

    public void addExisting(Path path) {
        String[] stringArray = path.list();
        int n = 0;
        while (n < stringArray.length) {
            File file = null;
            file = this.project != null ? this.project.resolveFile(stringArray[n]) : new File(stringArray[n]);
            if (file.exists()) {
                this.setLocation(file);
            }
            ++n;
        }
    }

    public String[] list() {
        Object object;
        Vector vector;
        if (!this.checked) {
            vector = new Stack<Path>();
            ((Stack)vector).push(this);
            this.dieOnCircularReference((Stack)vector, this.project);
        }
        vector = new Vector(2 * this.elements.size());
        int n = 0;
        while (n < this.elements.size()) {
            Object object2;
            object = this.elements.elementAt(n);
            if (object instanceof Reference && !((object = ((Reference)(object2 = (String[])object)).getReferencedObject(this.project)) instanceof Path)) {
                String string = ((Reference)object2).getRefId() + " doesn't denote a path";
                throw new BuildException(string);
            }
            if (object instanceof String) {
                Path.addUnlessPresent(vector, (String)object);
            } else if (object instanceof PathElement) {
                object2 = ((PathElement)object).getParts();
                if (object2 == null) {
                    throw new BuildException("You must either set location or path on <pathelement>");
                }
                int n2 = 0;
                while (n2 < ((String[])object2).length) {
                    Path.addUnlessPresent(vector, (String)object2[n2]);
                    ++n2;
                }
            } else if (object instanceof Path) {
                object2 = ((Path)object).list();
                int n3 = 0;
                while (n3 < ((String[])object2).length) {
                    Path.addUnlessPresent(vector, (String)object2[n3]);
                    ++n3;
                }
            } else if (object instanceof FileSet) {
                object2 = (FileSet)object;
                DirectoryScanner directoryScanner = ((FileSet)object2).getDirectoryScanner(this.project);
                String[] stringArray = directoryScanner.getIncludedFiles();
                File file = ((FileSet)object2).getDir(this.project);
                int n4 = 0;
                while (n4 < stringArray.length) {
                    String string;
                    File file2 = new File(file, stringArray[n4]);
                    try {
                        string = file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = file2.getAbsolutePath();
                    }
                    Path.addUnlessPresent(vector, Path.translateFile(string));
                    ++n4;
                }
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String toString() {
        String[] stringArray = this.list();
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0].toString());
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(File.pathSeparatorChar);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] translatePath(Project project, String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return new String[0];
        }
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (pathTokenizer.hasMoreTokens()) {
            stringBuffer.setLength(0);
            stringBuffer.append(Path.resolveFile(project, pathTokenizer.nextToken()));
            int n = 0;
            while (n < stringBuffer.length()) {
                Path.translateFileSep(stringBuffer, n);
                ++n;
            }
            vector.addElement(stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String translateFile(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            Path.translateFileSep(stringBuffer, n);
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static boolean translateFileSep(StringBuffer stringBuffer, int n) {
        if (stringBuffer.charAt(n) == '/' || stringBuffer.charAt(n) == '\\') {
            stringBuffer.setCharAt(n, File.separatorChar);
            return true;
        }
        return false;
    }

    public int size() {
        return this.list().length;
    }

    public Object clone() {
        Path path = new Path(this.project);
        path.append(this);
        return path;
    }

    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.checked) {
            return;
        }
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof Reference) {
                object = ((Reference)object).getReferencedObject(project);
            }
            if (!(object instanceof DataType)) continue;
            if (stack.contains(object)) {
                throw this.circularReference();
            }
            stack.push(object);
            ((DataType)object).dieOnCircularReference(stack, project);
            stack.pop();
        }
        this.checked = true;
    }

    private static String resolveFile(Project project, String string) {
        if (project != null) {
            File file = project.resolveFile(string);
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                project.log(iOException.getMessage(), 1);
                return file.getAbsolutePath();
            }
        }
        return string;
    }

    private static void addUnlessPresent(Vector vector, String string) {
        if (vector.indexOf(string) == -1) {
            vector.addElement(string);
        }
    }

    public Path concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public Path concatSystemClasspath(String string) {
        Path path = new Path(this.project);
        String string2 = this.project.getProperty("build.sysclasspath");
        if (string2 == null) {
            string2 = string;
        }
        if (string2.equals("only")) {
            path.addExisting(systemClasspath);
        } else if (string2.equals("first")) {
            path.addExisting(systemClasspath);
            path.addExisting(this);
        } else if (string2.equals("ignore")) {
            path.addExisting(this);
        } else {
            if (!string2.equals("last")) {
                this.project.log("invalid value for build.sysclasspath: " + string2, 1);
            }
            path.addExisting(this);
            path.addExisting(systemClasspath);
        }
        return path;
    }

    public class PathElement {
        private String[] parts;

        public void setLocation(File file) {
            try {
                this.parts = new String[]{Path.translateFile(file.getCanonicalPath())};
            }
            catch (IOException iOException) {
                if (Path.this.project != null) {
                    Path.this.project.log(iOException.getMessage(), 1);
                }
                this.parts = new String[]{Path.translateFile(file.getAbsolutePath())};
            }
        }

        public void setPath(String string) {
            this.parts = Path.translatePath(Path.this.project, string);
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

