/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.vfs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.excalibur.vfs.VFileAccessor;
import org.apache.avalon.excalibur.vfs.VFileFilter;
import org.apache.avalon.excalibur.vfs.VFileSystem;

public final class VFile {
    private final String m_path;
    private Object m_resource;
    private VFileAccessor m_accessor;
    private VFileSystem m_filesystem;

    public String getPath() {
        return this.m_path;
    }

    public String getName() {
        int index = this.m_path.lastIndexOf(47);
        if (-1 == index) {
            return this.m_path;
        }
        return this.m_path.substring(index);
    }

    public VFile getParent() throws IOException {
        this.checkValid();
        return this.m_filesystem.get(this.getParentsName());
    }

    public VFile[] list() throws IOException {
        this.checkValid();
        return this.m_filesystem.list(this);
    }

    public VFile[] list(VFileFilter filter) throws IOException {
        this.checkValid();
        return this.m_filesystem.list(this, filter);
    }

    public boolean isDirectory() {
        return this.m_resource == null;
    }

    public boolean isFile() {
        return this.m_resource != null;
    }

    public long getSize() throws IOException {
        this.checkValid();
        if (this.isDirectory()) {
            return 0L;
        }
        return this.m_accessor.getSize(this, this.m_resource);
    }

    public InputStream getInputStream() throws IOException {
        this.checkValid();
        if (this.isDirectory()) {
            return null;
        }
        return this.m_accessor.getInputStream(this, this.m_resource);
    }

    public boolean isValid() {
        return this.m_filesystem != null;
    }

    protected void invalidate() {
        this.m_filesystem = null;
        this.m_resource = null;
        this.m_accessor = null;
    }

    private void checkValid() throws IOException {
        if (!this.isValid()) {
            throw new IOException("Invalid VFile");
        }
    }

    private String getParentsName() {
        int index = this.m_path.lastIndexOf(47);
        if (-1 == index) {
            return this.m_path;
        }
        return this.m_path.substring(0, index);
    }

    protected VFile(String path, VFileSystem filesystem) {
        this(path, filesystem, null, null);
    }

    protected VFile(String path, VFileSystem filesystem, Object resource, VFileAccessor accessor) throws IllegalArgumentException {
        this.m_path = path;
        this.m_filesystem = filesystem;
        this.m_resource = resource;
        this.m_accessor = accessor;
        if ((resource == null || accessor == null) && resource != null && accessor != null) {
            throw new IllegalArgumentException("Resource and accessor must be both null or non-null");
        }
    }
}

