/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.apache.avalon.excalibur.source.ModifiableSource;
import org.apache.avalon.excalibur.source.SourceParameters;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.excalibur.xml.XMLizable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class URLSource
implements ModifiableSource,
XMLizable {
    private static boolean checkedURLClass = false;
    private static boolean urlSupportsGetUserInfo = false;
    private static Method urlGetUserInfo = null;
    private static Object[] emptyParams = new Object[0];
    public static final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private final String FILE;
    private long lastModificationDate;
    private long contentLength;
    private String systemId;
    private URL url;
    private URLConnection connection;
    private boolean isFile;
    private boolean gotInfos;
    private ComponentManager manager;
    private static /* synthetic */ Class class$Ljava$net$URL;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    private void getInfos() {
        if (!this.gotInfos) {
            if (this.isFile) {
                File file = new File(this.systemId.substring("file:".length()));
                this.lastModificationDate = file.lastModified();
                this.contentLength = file.length();
            } else {
                try {
                    if (this.connection == null) {
                        this.connection = this.url.openConnection();
                        String userInfo = this.getUserInfo();
                        if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                            this.connection.setRequestProperty("Authorization", "Basic " + URLSource.encodeBASE64(userInfo));
                        }
                    }
                    this.lastModificationDate = this.connection.getLastModified();
                    this.contentLength = this.connection.getContentLength();
                }
                catch (IOException ignore) {
                    this.lastModificationDate = 0L;
                    this.contentLength = -1L;
                }
            }
            this.gotInfos = true;
        }
    }

    public long getLastModified() {
        this.getInfos();
        return this.lastModificationDate;
    }

    public long getContentLength() {
        this.getInfos();
        return this.contentLength;
    }

    public InputStream getInputStream() throws IOException {
        this.getInfos();
        InputStream input = null;
        if (this.isFile) {
            input = new FileInputStream(this.systemId.substring("file:".length()));
        } else {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
                String userInfo = this.getUserInfo();
                if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                    this.connection.setRequestProperty("Authorization", "Basic " + URLSource.encodeBASE64(userInfo));
                }
            }
            input = this.connection.getInputStream();
            this.connection = null;
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private String getUserInfo() {
        if (checkedURLClass) {
            if (urlSupportsGetUserInfo) {
                try {
                    return (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            void e;
            urlGetUserInfo = (class$Ljava$net$URL != null ? class$Ljava$net$URL : (class$Ljava$net$URL = URLSource.class$("java.net.URL"))).getMethod("getUserInfo", null);
            String ui = (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
            checkedURLClass = true;
            urlSupportsGetUserInfo = true;
            return e;
        }
        catch (Exception exception) {
            checkedURLClass = true;
            urlSupportsGetUserInfo = false;
            urlGetUserInfo = null;
            return null;
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void refresh() {
        this.connection = null;
        this.gotInfos = false;
    }

    public InputSource getInputSource() throws IOException {
        InputSource newObject = new InputSource(this.getInputStream());
        newObject.setSystemId(this.systemId);
        return newObject;
    }

    public static String encodeBASE64(String s) {
        return URLSource.encodeBASE64(s.getBytes());
    }

    public static String encodeBASE64(byte[] octetString) {
        int bits6;
        int bits24;
        char[] out = new char[((octetString.length - 1) / 3 + 1) * 4];
        int outIndex = 0;
        int i = 0;
        while (i + 3 <= octetString.length) {
            bits24 = (octetString[i++] & 0xFF) << 16;
            bits24 |= (octetString[i++] & 0xFF) << 8;
            bits6 = ((bits24 |= octetString[i++] & 0xFF) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            bits6 = bits24 & 0x3F;
            out[outIndex++] = alphabet[bits6];
        }
        if (octetString.length - i == 2) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = ((bits24 |= (octetString[i + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
        } else if (octetString.length - i == 1) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = (bits24 & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
            out[outIndex++] = 61;
        }
        return new String(out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        Parser parser = null;
        try {
            try {
                parser = (Parser)this.manager.lookup("org.apache.avalon.excalibur.xml.Parser");
                parser.parse(this.getInputSource(), handler);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Exception during processing of " + this.systemId, e);
            }
            Object var4_3 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (parser == null) throw throwable;
            this.manager.release((Component)parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public URLSource(URL url, SourceParameters parameters) throws IOException {
        this.FILE = "file:";
        this.systemId = url.toExternalForm();
        this.isFile = this.systemId.startsWith("file:");
        this.url = url;
        this.gotInfos = false;
    }
}

