/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log.Hierarchy;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.AbstractOutputTarget;

public class DefaultOutputLogTarget
extends AbstractOutputTarget {
    protected Writer m_output;

    protected void initPattern() {
        PatternFormatter formatter = new PatternFormatter();
        formatter.setFormat("%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}");
        this.m_formatter = formatter;
    }

    protected void output(String data) {
        try {
            this.m_output.write(data);
            this.m_output.flush();
        }
        catch (IOException ioe) {
            Hierarchy.getDefaultHierarchy().log("Caught an IOException", ioe);
        }
    }

    public void setFormat(String format) {
        ((PatternFormatter)this.m_formatter).setFormat(format);
    }

    public DefaultOutputLogTarget() {
        this(new OutputStreamWriter(System.out));
    }

    public DefaultOutputLogTarget(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public DefaultOutputLogTarget(Writer writer) {
        this.m_output = writer;
        this.initPattern();
    }
}

