/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.naming.rmi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import org.apache.avalon.excalibur.naming.DefaultNamespace;
import org.apache.avalon.excalibur.naming.Namespace;
import org.apache.avalon.excalibur.naming.NamingProvider;
import org.apache.avalon.excalibur.naming.RemoteContext;

public class RMIInitialContextFactory
implements InitialContextFactory {
    public Context getInitialContext(Hashtable environment) throws NamingException {
        NamingProvider provider = this.newNamingProvider(environment);
        environment.put("org.apache.avalon.excalibur.naming.NamingProvider", provider);
        Namespace namespace = this.newNamespace(environment);
        environment.put("org.apache.avalon.excalibur.naming.Namespace", namespace);
        return new RemoteContext(environment, namespace.getNameParser().parse(""));
    }

    protected NamingProvider newNamingProvider(Hashtable environment) throws NamingException {
        int index;
        String url = (String)environment.get("java.naming.provider.url");
        if (url == null) {
            return this.newNamingProvider("localhost", 1977);
        }
        if (!url.startsWith("rmi://")) {
            throw new ConfigurationException("Malformed url - " + url);
        }
        int end = index = url.indexOf(58, 6);
        int port = 1977;
        if (-1 == index) {
            end = url.length();
        } else {
            port = Integer.parseInt(url.substring(index + 1));
        }
        String host = url.substring(6, end);
        return this.newNamingProvider(host, port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamingProvider newNamingProvider(String host, int port) throws NamingException {
        Socket socket = null;
        try {
            try {
                socket = new Socket(host, port);
                ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                NamingProvider provider = (NamingProvider)((MarshalledObject)input.readObject()).get();
                socket.close();
                NamingProvider namingProvider = provider;
                Object var5_10 = null;
                if (socket == null) return namingProvider;
                try {
                    socket.close();
                    return namingProvider;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return namingProvider;
            }
            catch (Exception e) {
                ServiceUnavailableException sue = new ServiceUnavailableException(e.getMessage());
                sue.setRootCause(e);
                throw sue;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (socket == null) throw throwable;
            try {}
            catch (IOException ioe) {
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
    }

    protected Namespace newNamespace(Hashtable environment) throws NamingException {
        try {
            NamingProvider provider = (NamingProvider)environment.get("org.apache.avalon.excalibur.naming.NamingProvider");
            return new DefaultNamespace(provider.getNameParser());
        }
        catch (Exception e) {
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            ServiceUnavailableException sue = new ServiceUnavailableException(e.getMessage());
            sue.setRootCause(e);
            throw sue;
        }
    }
}

