/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import java.util.NoSuchElementException;
import org.apache.avalon.excalibur.collections.PriorityQueue;

public final class BinaryHeap
implements PriorityQueue {
    protected static final int DEFAULT_CAPACITY = 13;
    protected int m_size;
    protected Comparable[] m_elements;
    protected boolean m_isMinHeap;

    public void clear() {
        this.m_size = 0;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public boolean isFull() {
        return this.m_elements.length == this.m_size + 1;
    }

    public void insert(Comparable element) {
        if (this.isFull()) {
            this.grow();
        }
        if (this.m_isMinHeap) {
            this.percolateUpMinHeap(element);
        } else {
            this.percolateUpMaxHeap(element);
        }
    }

    public Comparable peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.m_elements[1];
    }

    public Comparable pop() throws NoSuchElementException {
        Comparable result = this.peek();
        this.m_elements[1] = this.m_elements[this.m_size--];
        this.m_elements[this.m_size + 1] = null;
        if (this.m_size != 0) {
            if (this.m_isMinHeap) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return result;
    }

    protected void percolateDownMinHeap(int index) {
        Comparable element = this.m_elements[index];
        int hole = index;
        while (hole * 2 <= this.m_size) {
            int child = hole * 2;
            if (child != this.m_size && this.m_elements[child + 1].compareTo(this.m_elements[child]) < 0) {
                ++child;
            }
            if (this.m_elements[child].compareTo(element) >= 0) break;
            this.m_elements[hole] = this.m_elements[child];
            hole = child;
        }
        this.m_elements[hole] = element;
    }

    protected void percolateDownMaxHeap(int index) {
        Comparable element = this.m_elements[index];
        int hole = index;
        while (hole * 2 <= this.m_size) {
            int child = hole * 2;
            if (child != this.m_size && this.m_elements[child + 1].compareTo(this.m_elements[child]) > 0) {
                ++child;
            }
            if (this.m_elements[child].compareTo(element) <= 0) break;
            this.m_elements[hole] = this.m_elements[child];
            hole = child;
        }
        this.m_elements[hole] = element;
    }

    protected void percolateUpMinHeap(Comparable element) {
        int hole = ++this.m_size;
        this.m_elements[hole] = element;
        while (hole > 1 && element.compareTo(this.m_elements[hole / 2]) < 0) {
            int next = hole / 2;
            this.m_elements[hole] = this.m_elements[next];
            hole = next;
        }
        this.m_elements[hole] = element;
    }

    protected void percolateUpMaxHeap(Comparable element) {
        int hole = ++this.m_size;
        while (hole > 1 && element.compareTo(this.m_elements[hole / 2]) > 0) {
            int next = hole / 2;
            this.m_elements[hole] = this.m_elements[next];
            hole = next;
        }
        this.m_elements[hole] = element;
    }

    protected void grow() {
        Comparable[] elements = new Comparable[this.m_elements.length * 2];
        System.arraycopy(this.m_elements, 0, elements, 0, this.m_elements.length);
        this.m_elements = elements;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        int i = 1;
        while (i < this.m_size + 1) {
            if (i != 1) {
                sb.append(", ");
            }
            sb.append(this.m_elements[i]);
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }

    public BinaryHeap() {
        this(13, true);
    }

    public BinaryHeap(int capacity) {
        this(capacity, true);
    }

    public BinaryHeap(boolean isMinHeap) {
        this(13, isMinHeap);
    }

    public BinaryHeap(int capacity, boolean isMinHeap) {
        this.m_isMinHeap = isMinHeap;
        this.m_elements = new Comparable[capacity + 1];
    }
}

