/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultConfigurationBuilder {
    protected static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    protected static final String PARSER = System.getProperty("org.xml.sax.parser", "org.apache.xerces.parsers.SAXParser");
    protected SAXConfigurationHandler m_handler = this.getHandler();
    protected XMLReader m_parser;

    public DefaultConfigurationBuilder() {
        this(PARSER);
    }

    public DefaultConfigurationBuilder(String string) {
        try {
            this.m_parser = XMLReaderFactory.createXMLReader(string);
            this.m_parser.setContentHandler(this.m_handler);
            this.m_parser.setErrorHandler(this.m_handler);
        }
        catch (SAXException sAXException) {
            throw new Error("Unable to setup SAX parser" + sAXException);
        }
    }

    protected SAXConfigurationHandler getHandler() {
        return new SAXConfigurationHandler();
    }

    public synchronized Configuration buildFromFile(String string) throws SAXException, IOException, ConfigurationException {
        return this.buildFromFile(new File(string));
    }

    public synchronized Configuration buildFromFile(File file) throws SAXException, IOException, ConfigurationException {
        this.m_handler.clear();
        this.m_parser.parse(file.toURL().toString());
        return this.m_handler.getConfiguration();
    }

    public synchronized Configuration build(InputStream inputStream) throws SAXException, IOException, ConfigurationException {
        InputSource inputSource = new InputSource(inputStream);
        return this.build(inputSource);
    }

    public synchronized Configuration build(InputSource inputSource) throws SAXException, IOException, ConfigurationException {
        this.m_handler.clear();
        this.m_parser.parse(inputSource);
        return this.m_handler.getConfiguration();
    }
}

