/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.excalibur.concurrent.Lock;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public abstract class AbstractPool
extends AbstractLoggable
implements Pool,
ThreadSafe {
    public static final int DEFAULT_POOL_SIZE = 8;
    protected final ObjectFactory m_factory;
    protected List m_active = new ArrayList();
    protected List m_ready = new ArrayList();
    protected Lock m_mutex = new Lock();
    protected boolean m_initialized = false;

    public AbstractPool(ObjectFactory objectFactory) throws Exception {
        this.m_factory = objectFactory;
        if (!(this instanceof Initializable)) {
            this.initialize();
        }
    }

    protected void initialize() throws Exception {
        this.m_mutex.lock();
        int n = 0;
        while (n < 8) {
            this.m_ready.add(this.newPoolable());
            ++n;
        }
        this.m_initialized = true;
        this.m_mutex.unlock();
    }

    protected Poolable newPoolable() throws Exception {
        Object object = this.m_factory.newInstance();
        return (Poolable)object;
    }

    protected void removePoolable(Poolable poolable) {
        try {
            this.m_factory.decommission(poolable);
        }
        catch (Exception exception) {
            this.getLogger().debug("Error decommissioning object", (Throwable)exception);
        }
    }

    protected final synchronized int size() {
        return this.m_active.size() + this.m_ready.size();
    }

    public abstract Poolable get() throws Exception;

    public abstract void put(Poolable var1);
}

