/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class DefaultComponentSelector
extends AbstractLoggable
implements Contextualizable,
ComponentSelector,
Composable,
Configurable,
ThreadSafe,
Disposable {
    private static final String DEFAULT_NAME = "UnnamedSelector";
    private String m_rolename;
    protected Context m_context;
    private ComponentManager m_componentManager;
    private Map m_componentMapping;
    private Configuration m_configuration;
    private Map m_componentHandlers = Collections.synchronizedMap(new HashMap());
    private boolean m_disposed;
    private Map m_hints;
    private RoleManager m_roles;

    public DefaultComponentSelector() {
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }

    public void contextualize(Context context) {
        if (null == this.m_context) {
            this.m_context = context;
        }
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        if (null == this.m_componentManager) {
            this.m_componentManager = componentManager;
        }
    }

    public synchronized void dispose() {
        this.m_disposed = true;
        Iterator<Object> iterator = this.m_componentHandlers.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ComponentHandler componentHandler = (ComponentHandler)((Object)this.m_componentHandlers.get(k));
            try {
                componentHandler.dispose();
            }
            catch (Exception exception) {
                this.getLogger().debug("Caught an exception disposing of component handler.", (Throwable)exception);
            }
            arrayList.add(k);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_componentHandlers.remove(iterator.next());
        }
        arrayList.clear();
    }

    public Component select(Object object) throws ComponentException {
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot select a Component from a disposed ComponentSelector");
        }
        if (null == object) {
            String string = this.getName() + ": ComponentSelector Attempted to retrieve component with null hint.";
            this.getLogger().error(string);
            throw new ComponentException(string);
        }
        ComponentHandler componentHandler = (ComponentHandler)((Object)this.m_componentHandlers.get(object));
        if (null == componentHandler) {
            String string = this.getName() + ": ComponentSelector could not find the component for hint: " + object;
            this.getLogger().debug(string);
            throw new ComponentException(string);
        }
        Component component = null;
        try {
            component = componentHandler.get();
        }
        catch (Exception exception) {
            String string = this.getName() + ": ComponentSelector could not access the Component for hint: " + object;
            this.getLogger().debug(string, (Throwable)exception);
            throw new ComponentException(string, (Throwable)exception);
        }
        if (null == component) {
            String string = this.getName() + ": ComponentSelector could not find the component for hint: " + object;
            this.getLogger().debug(string);
            throw new ComponentException(string);
        }
        this.m_componentMapping.put(component, componentHandler);
        return component;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
        this.getLogger().debug("ComponentSelector setting up with root element: " + this.m_configuration.getName());
        String string = configuration.getName();
        this.m_rolename = string.equals("component") ? this.m_configuration.getAttribute("role") : this.m_roles.getRoleForName(string);
        Configuration[] configurationArray = this.m_configuration.getChildren();
        int n = 0;
        while (n < configurationArray.length) {
            String string2 = configurationArray[n].getAttribute("name").trim();
            String string3 = "component-instance".equals(configurationArray[n].getName()) ? configurationArray[n].getAttribute("class").trim() : this.m_roles.getDefaultClassNameForHint(this.m_rolename, configurationArray[n].getName());
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(string3);
                this.addComponent(string2, clazz, configurationArray[n]);
            }
            catch (Exception exception) {
                String string4 = "The component instance for '" + string2 + "' has an invalid class name.";
                this.getLogger().error(string4, (Throwable)exception);
                throw new ConfigurationException(string4, (Throwable)exception);
            }
            ++n;
        }
    }

    public void setRoleManager(RoleManager roleManager) {
        if (null == this.m_roles) {
            this.m_roles = roleManager;
        }
    }

    public void release(Component component) {
        if (null == component) {
            return;
        }
        ComponentHandler componentHandler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
        if (null == componentHandler) {
            return;
        }
        try {
            componentHandler.put(component);
        }
        catch (Exception exception) {
            this.getLogger().debug("Error trying to release component", (Throwable)exception);
        }
        this.m_componentMapping.remove(component);
    }

    public void addComponent(Object object, Class clazz, Configuration configuration) throws ComponentException {
        try {
            ComponentHandler componentHandler = ComponentHandler.getComponentHandler(clazz, configuration, this.m_componentManager, this.m_context, this.m_roles);
            componentHandler.setLogger(this.getLogger());
            componentHandler.initialize();
            this.m_componentHandlers.put(object, componentHandler);
            this.getLogger().debug("Adding " + clazz.getName() + " for " + object.toString());
        }
        catch (Exception exception) {
            String string = "Could not set up Component for hint: " + object;
            this.getLogger().error(string, (Throwable)exception);
            throw new ComponentException(string, (Throwable)exception);
        }
    }

    public void addComponentInstance(String string, Object object) {
        try {
            ComponentHandler componentHandler = ComponentHandler.getComponentHandler((Component)object);
            componentHandler.setLogger(this.getLogger());
            componentHandler.initialize();
            this.m_componentHandlers.put(string, componentHandler);
            this.getLogger().debug("Adding " + object.getClass().getName() + " for " + string.toString());
        }
        catch (Exception exception) {
            this.getLogger().error("Could not set up Component for hint: " + string, (Throwable)exception);
        }
    }

    private String getName() {
        if (null != this.m_configuration && !this.m_configuration.getName().equals("")) {
            return this.m_configuration.getName();
        }
        return DEFAULT_NAME;
    }
}

