/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.DefaultComponentSelector;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class DefaultComponentFactory
extends AbstractLoggable
implements ObjectFactory,
ThreadSafe {
    private Class m_componentClass;
    private Context m_context;
    private ComponentManager m_componentManager;
    private Configuration m_configuration;
    private RoleManager m_roles;

    public DefaultComponentFactory(Class clazz, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roleManager) {
        this.m_componentClass = clazz;
        this.m_configuration = configuration;
        this.m_componentManager = componentManager;
        this.m_context = context;
        this.m_roles = roleManager;
    }

    public Object newInstance() throws Exception {
        Object t = this.m_componentClass.newInstance();
        this.getLogger().debug("ComponentFactory creating new instance of " + this.m_componentClass.getName() + ".");
        if (t instanceof Loggable) {
            ((Loggable)t).setLogger(this.getLogger());
        }
        if (t instanceof Contextualizable) {
            ((Contextualizable)t).contextualize(this.m_context);
        }
        if (t instanceof Composable) {
            ((Composable)t).compose(this.m_componentManager);
        }
        if (t instanceof DefaultComponentSelector) {
            ((DefaultComponentSelector)((Object)t)).setRoleManager(this.m_roles);
        }
        if (t instanceof Configurable) {
            ((Configurable)t).configure(this.m_configuration);
        }
        if (t instanceof Initializable) {
            ((Initializable)t).initialize();
        }
        if (t instanceof Startable) {
            ((Startable)t).start();
        }
        return t;
    }

    public final Class getCreatedClass() {
        return this.m_componentClass;
    }

    public final void decommission(Object object) throws Exception {
        this.getLogger().debug("ComponentFactory decommissioning instance of " + this.m_componentClass.getName() + ".");
        if (object instanceof Startable) {
            ((Startable)object).stop();
        }
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
        }
    }
}

