/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import xjavadoc.AbstractClass;
import xjavadoc.AbstractProgramElement;
import xjavadoc.ClassIterator;
import xjavadoc.MemberImpl;
import xjavadoc.ParameterImpl;
import xjavadoc.Util;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XExecutableMember;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;

abstract class AbstractExecutableMember
extends MemberImpl
implements XExecutableMember {
    private static final int MAX_ARRAY_SIZE = 6;
    private static final Integer[] _dimensions = new Integer[6];
    private static final int PARAMETER_DATA_SIZE = 2;
    private static final int INITIAL_PARAMETER_POOL_SIZE = 20;
    private static ParameterImpl[] _parameterPool = new ParameterImpl[20];
    private List _thrownExceptions;
    private List _parameterData;
    private String _nameWithSignature;
    private String _signature;
    private String _stringId;

    protected AbstractExecutableMember(AbstractClass containingClass) {
        super(containingClass);
        if (containingClass == null) {
            throw new IllegalArgumentException("containingClass can't be null");
        }
    }

    private static final String toString(XParameter parameter, boolean withParam) {
        if (parameter == null) {
            throw new IllegalStateException("parameter can't be null!");
        }
        StringBuffer sb = new StringBuffer(parameter.getType().getQualifiedName());
        Util.appendDimensionAsString(parameter.getDimension(), sb);
        if (withParam) {
            sb.append(" ").append(parameter.getName());
        }
        return sb.toString();
    }

    public final boolean isNative() {
        return (this.getModifierSpecifier() & 0x100) != 0;
    }

    public final boolean isSynchronized() {
        return (this.getModifierSpecifier() & 0x20) != 0;
    }

    public final List getParameters() {
        ArrayList<ParameterImpl> parameters = null;
        if (this._parameterData == null) {
            parameters = AbstractProgramElement.EMPTY_LIST;
        } else {
            int requiredSize = this._parameterData.size() / 3;
            parameters = new ArrayList<ParameterImpl>(requiredSize);
            if (_parameterPool.length < requiredSize) {
                ParameterImpl[] newPool = new ParameterImpl[requiredSize];
                System.arraycopy(_parameterPool, 0, newPool, 0, _parameterPool.length);
                int j = _parameterPool.length;
                while (j < newPool.length) {
                    newPool[j] = new ParameterImpl();
                    ++j;
                }
                _parameterPool = newPool;
            }
            int i = 0;
            while (i < requiredSize) {
                try {
                    _parameterPool[i].setState(this, i);
                    parameters.add(_parameterPool[i]);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalStateException("In member " + this.getName() + ". Tried to set " + i + "th parameter. Size was " + requiredSize);
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(parameters);
    }

    public final String getSignature() {
        return this.getSignature(false);
    }

    public final String getNameWithSignature() {
        return this.getNameWithSignature(false);
    }

    public final String getSignature(boolean withParam) {
        if (this._signature == null) {
            this._signature = this.appendSignature(new StringBuffer(), withParam).toString();
        }
        return this._signature;
    }

    public final String getNameWithSignature(boolean withParam) {
        if (this._nameWithSignature == null) {
            this._nameWithSignature = this.appendSignature(new StringBuffer(this.getName()), withParam).toString();
        }
        return this._nameWithSignature;
    }

    public String getParameterTypes() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getParameters().iterator();
        while (i.hasNext()) {
            ((XParameter)i.next()).getType();
        }
        boolean comma = false;
        Iterator i2 = this.getParameters().iterator();
        while (i2.hasNext()) {
            if (comma) {
                sb.append(',');
            }
            XParameter parameter = (XParameter)i2.next();
            sb.append(parameter.getType().getType());
            comma = true;
        }
        return sb.toString();
    }

    public List getThrownExceptions() {
        return this._thrownExceptions == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this.getQualifiedExceptions());
    }

    public XProgramElement getSuperElement(boolean forMethod) {
        XClass superclass = this.getContainingClass().getSuperclass();
        while (superclass != null) {
            XExecutableMember superExecutableMember = forMethod ? superclass.getMethod(this.getNameWithSignature(false)) : superclass.getConstructor(this.getNameWithSignature(false));
            if (superExecutableMember != null) {
                return superExecutableMember;
            }
            superclass = superclass.getSuperclass();
        }
        return null;
    }

    public boolean throwsException(String exception_class_name) {
        ClassIterator iterator = XCollections.classIterator(this.getThrownExceptions());
        while (iterator.hasNext()) {
            XClass exception = iterator.next();
            if (!exception.getQualifiedName().equals(exception_class_name)) continue;
            return true;
        }
        return false;
    }

    public void addParameterData(String type, String name, int dimension) {
        if (this._parameterData == null) {
            this._parameterData = new ArrayList(6);
        }
        this._parameterData.add(type);
        this._parameterData.add(name);
        this._parameterData.add(_dimensions[dimension]);
    }

    public void addThrownException(String thrownException) {
        if (this._thrownExceptions == null) {
            this._thrownExceptions = new ArrayList();
        }
        this._thrownExceptions.add(thrownException);
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractExecutableMember other = (AbstractExecutableMember)o;
        return this.stringId().equals(other.stringId());
    }

    public int hashCode() {
        return this.stringId().hashCode();
    }

    public String toString() {
        return this.stringId();
    }

    protected abstract String buildStringId();

    final String getParameterType(int index) {
        return (String)this._parameterData.get(index * 3);
    }

    final String getParameterName(int index) {
        return (String)this._parameterData.get(index * 3 + 1);
    }

    final int getParameterDimension(int index) {
        return (Integer)this._parameterData.get(index * 3 + 2);
    }

    private List getQualifiedExceptions() {
        if (this._thrownExceptions.get(0) instanceof String) {
            ArrayList<XClass> qualified_thrown_exceptions = new ArrayList<XClass>();
            Iterator iterator = this._thrownExceptions.iterator();
            while (iterator.hasNext()) {
                String exception_class_name = (String)iterator.next();
                qualified_thrown_exceptions.add(this.getContainingAbstractClass().qualify(exception_class_name));
            }
            this._thrownExceptions = qualified_thrown_exceptions;
        }
        return this._thrownExceptions;
    }

    private final String stringId() {
        if (this._stringId == null) {
            this._stringId = this.buildStringId();
        }
        return this._stringId;
    }

    private final StringBuffer appendSignature(StringBuffer sb, boolean withParam) {
        sb.append('(');
        Iterator i = this.getParameters().iterator();
        while (i.hasNext()) {
            ((XParameter)i.next()).getType();
        }
        boolean comma = false;
        Iterator i2 = this.getParameters().iterator();
        while (i2.hasNext()) {
            if (comma) {
                sb.append(',');
            }
            sb.append(AbstractExecutableMember.toString((XParameter)i2.next(), withParam));
            comma = true;
        }
        return sb.append(')');
    }

    static {
        int i = 0;
        while (i < 6) {
            AbstractExecutableMember._dimensions[i] = new Integer(i);
            ++i;
        }
        i = 0;
        while (i < 20) {
            AbstractExecutableMember._parameterPool[i] = new ParameterImpl();
            ++i;
        }
    }
}

